/*
 * Decompiled with CFR 0.152.
 */
package com.biborne.fxmlcache;

import com.biborne.fxmlcache.FXMLCacheEntry;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.layout.Region;

public abstract class FXMLCacheManager {
    private static final Map<String, FXMLCacheEntry<?>> fxmlCache = new HashMap();

    public static <T> FXMLCacheEntry<T> loadFXML(String fxmlFile) {
        FXMLCacheEntry<Object> fxmlCachedEntry = fxmlCache.get(fxmlFile);
        if (fxmlCachedEntry == null) {
            try {
                FXMLLoader loader = new FXMLLoader(FXMLCacheManager.class.getResource(fxmlFile));
                Parent rootNode = (Parent)loader.load();
                fxmlCachedEntry = new FXMLCacheEntry<Object>(rootNode, loader.getController());
                fxmlCache.put(fxmlFile, fxmlCachedEntry);
            }
            catch (IOException ex) {
                Logger.getLogger(FXMLCacheManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            FXMLCacheManager.detachFromExistingScene(fxmlCachedEntry.getRootNode());
            System.gc();
        }
        return fxmlCachedEntry;
    }

    public static void unloadFXML(String fxmlFile) {
        FXMLCacheEntry<?> fxmlCachedEntry = fxmlCache.remove(fxmlFile);
        if (fxmlCachedEntry != null) {
            FXMLCacheManager.detachFromExistingScene(fxmlCachedEntry.getRootNode());
            System.gc();
        }
    }

    public static void clear() {
        for (FXMLCacheEntry<?> fxmlCachedEntry : fxmlCache.values()) {
            FXMLCacheManager.detachFromExistingScene(fxmlCachedEntry.getRootNode());
        }
        fxmlCache.clear();
        System.gc();
    }

    private static void detachFromExistingScene(Parent rootNode) {
        if (rootNode != null && rootNode.getScene() != null) {
            rootNode.getScene().setRoot((Parent)new Region());
        }
    }
}

