/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.utility;

import com.scriptbasic.errors.BasicInterpreterInternalError;
import com.scriptbasic.log.Logger;
import com.scriptbasic.log.LoggerFactory;
import com.scriptbasic.utility.NoInstance;

public class NumberUtility {
    private static final Logger LOG = LoggerFactory.getLogger();

    private NumberUtility() {
        NoInstance.isPossible();
    }

    private static void assertPreconditions(Number a, Number b) {
        if (a == null || b == null) {
            throw new BasicInterpreterInternalError("Can not compare null to something");
        }
        if (a.getClass() != b.getClass()) {
            throw new BasicInterpreterInternalError("Can not compare different number types: " + a.getClass() + " != " + b.getClass());
        }
        if (!(a instanceof Long) && !(a instanceof Double)) {
            throw new BasicInterpreterInternalError("Only double and long can be compared as Numbers");
        }
    }

    public static boolean isPositive(Number a) {
        LOG.debug("a {} is instance of Long = {}", a, a instanceof Long);
        Number zero = a instanceof Long ? (Number)0L : (Number)0.0;
        LOG.debug("Calling compare with arguments '{}' '{}' of classes '{}' and '{}'", a, zero, a.getClass(), zero.getClass());
        return NumberUtility.compare(a, zero) > 0;
    }

    public static int compare(Number a, Number b) {
        int retval;
        if (a == null && b == null) {
            return 0;
        }
        NumberUtility.assertPreconditions(a, b);
        if (a instanceof Double) {
            Double aA = (Double)a;
            Double bB = (Double)b;
            retval = aA > bB ? 1 : (aA.equals(bB) ? 0 : -1);
        } else {
            Long aA = (Long)a;
            Long bB = (Long)b;
            retval = aA > bB ? 1 : (aA.equals(bB) ? 0 : -1);
        }
        return retval;
    }
}

