/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.utility;

import com.scriptbasic.exceptions.LexicalException;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.BasicSyntaxException;
import com.scriptbasic.interfaces.LexicalAnalyzer;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.utility.NoInstance;

public final class LexUtility {
    private LexUtility() {
        NoInstance.isPossible();
    }

    public static LexicalElement peek(LexicalAnalyzer lexicalAnalyzer) throws AnalysisException {
        try {
            return lexicalAnalyzer.peek();
        }
        catch (LexicalException e) {
            throw new BasicSyntaxException(e);
        }
    }

    public static LexicalElement get(LexicalAnalyzer lexicalAnalyzer) throws AnalysisException {
        try {
            return lexicalAnalyzer.get();
        }
        catch (LexicalException e) {
            throw new BasicSyntaxException(e);
        }
    }

    public static boolean isLexeme(LexicalAnalyzer analyzer, String lexeme) throws AnalysisException {
        LexicalElement lexicalElement = analyzer.peek();
        if (lexicalElement != null && lexicalElement.isSymbol().booleanValue() && lexeme.equalsIgnoreCase(lexicalElement.getLexeme())) {
            analyzer.get();
            return true;
        }
        return false;
    }

    public static void checkLexeme(LexicalAnalyzer analyzer, String lexeme, String exceptionText) throws AnalysisException {
        if (!LexUtility.isLexeme(analyzer, lexeme)) {
            throw new BasicSyntaxException(exceptionText);
        }
    }
}

