/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax.commands;

import com.scriptbasic.context.Context;
import com.scriptbasic.executors.commands.CommandCall;
import com.scriptbasic.executors.commands.CommandLet;
import com.scriptbasic.executors.leftvalues.BasicLeftValue;
import com.scriptbasic.executors.rightvalues.FunctionCall;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.BasicSyntaxException;
import com.scriptbasic.interfaces.ExpressionList;
import com.scriptbasic.interfaces.LexicalAnalyzer;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.spi.Command;
import com.scriptbasic.syntax.commands.AbstractCommandAnalyzer;

public class CommandAnalyzerCall
extends AbstractCommandAnalyzer {
    public CommandAnalyzerCall(Context ctx) {
        super(ctx);
    }

    @Override
    public Command analyze() throws AnalysisException {
        LexicalElement lexicalElement;
        this.skipTheOptionalCallKeyword();
        BasicLeftValue lv = (BasicLeftValue)this.ctx.leftValueAnalyzer.analyze();
        if (lv.hasModifiers()) {
            this.ctx.lexicalAnalyzer.resetLine();
            CommandLet commandLet = new CommandLet();
            commandLet.setExpression(this.ctx.expressionAnalyzer.analyze());
            this.consumeEndOfStatement();
            return commandLet;
        }
        String functionName = lv.getIdentifier();
        FunctionCall functionCall = new FunctionCall();
        functionCall.setVariableName(functionName);
        boolean needClosingParenthesis = this.argumentsAreBetweenParentheses(this.ctx.lexicalAnalyzer);
        if (needClosingParenthesis) {
            this.ctx.lexicalAnalyzer.get();
        }
        if (this.thereAreArguments(needClosingParenthesis, lexicalElement = this.ctx.lexicalAnalyzer.peek())) {
            functionCall.setExpressionList((ExpressionList)this.ctx.expressionListAnalyzer.analyze());
        } else {
            functionCall.setExpressionList(null);
        }
        if (needClosingParenthesis) {
            this.consumeClosingParenthesis(this.ctx.lexicalAnalyzer);
        }
        this.consumeEndOfStatement();
        return new CommandCall(functionCall);
    }

    private boolean thereAreArguments(boolean needClosingParenthesis, LexicalElement lexicalElement) {
        return lexicalElement != null && lexicalElement.isSymbol(needClosingParenthesis ? ")" : "\n") == false;
    }

    private void consumeClosingParenthesis(LexicalAnalyzer lexicalAnalyzer) throws AnalysisException {
        LexicalElement closingParenthesis = lexicalAnalyzer.peek();
        if (closingParenthesis == null || !closingParenthesis.isSymbol(")").booleanValue()) {
            throw new BasicSyntaxException("The closing ) is missing after the CALL statement");
        }
        lexicalAnalyzer.get();
    }

    private boolean argumentsAreBetweenParentheses(LexicalAnalyzer lexicalAnalyzer) throws AnalysisException {
        LexicalElement openingParenthesis = lexicalAnalyzer.peek();
        return openingParenthesis != null && openingParenthesis.isSymbol("(") != false;
    }

    private void skipTheOptionalCallKeyword() throws AnalysisException {
        LexicalElement lexicalElement = this.ctx.lexicalAnalyzer.peek();
        if (lexicalElement != null && lexicalElement.isSymbol(this.getName()).booleanValue()) {
            this.ctx.lexicalAnalyzer.get();
        }
    }
}

