/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.lexer;

import com.scriptbasic.lexer.AbstractLexicalElement;
import com.scriptbasic.utility.CharUtils;

public class BasicLexicalElement
extends AbstractLexicalElement {
    private String fileName;
    private int lineNumber;
    private int position;
    private int type;
    private String lexeme;
    private String stringValue;
    private Long longValue;
    private Double doubleValue;
    private Boolean booleanValue;

    @Override
    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    @Override
    public String getLexeme() {
        return this.lexeme;
    }

    public void setLexeme(String lexeme) {
        this.lexeme = lexeme;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    private void resetValues() {
        this.stringValue = null;
        this.doubleValue = null;
        this.longValue = null;
        this.booleanValue = null;
    }

    public void setStringValue(String stringValue) {
        this.resetValues();
        this.stringValue = stringValue;
    }

    public void setLongValue(long longValue) {
        this.resetValues();
        this.longValue = longValue;
    }

    public void setDoubleValue(Double doubleValue) {
        this.resetValues();
        this.doubleValue = doubleValue;
    }

    public void setBooleanValue(Boolean booleanValue) {
        this.resetValues();
        this.booleanValue = booleanValue;
    }

    @Override
    public String stringValue() {
        return this.stringValue;
    }

    @Override
    public Long longValue() {
        return this.longValue;
    }

    @Override
    public Double doubleValue() {
        return this.doubleValue;
    }

    @Override
    public Boolean booleanValue() {
        return this.booleanValue;
    }

    @Override
    public Boolean isBoolean() {
        return this.getType() == 3;
    }

    @Override
    public Boolean isString() {
        return this.getType() == 0;
    }

    @Override
    public Boolean isDouble() {
        return this.getType() == 1;
    }

    @Override
    public Boolean isLong() {
        return this.getType() == 2;
    }

    @Override
    public Boolean isIdentifier() {
        return this.getType() == 4;
    }

    @Override
    public Boolean isSymbol() {
        return this.getType() == 5;
    }

    @Override
    public Boolean isSymbol(String lexeme) {
        return this.isSymbol() != false && lexeme.equalsIgnoreCase(this.getLexeme());
    }

    public String toString() {
        Object buffer;
        switch (this.type) {
            case 3: {
                buffer = "Boolean(" + this.booleanValue + ")";
                break;
            }
            case 1: {
                buffer = "Double(" + this.doubleValue + ")";
                break;
            }
            case 2: {
                buffer = "Long(" + this.longValue + ")";
                break;
            }
            case 0: {
                buffer = "String(\"" + this.stringValue + "\")";
                break;
            }
            case 4: {
                buffer = "'" + this.lexeme + "'";
                break;
            }
            case 5: {
                if (this.isLineTerminator().booleanValue()) {
                    buffer = "new-line";
                    break;
                }
                buffer = this.lexeme;
                break;
            }
            default: {
                buffer = "INVALID-TYPE";
            }
        }
        return buffer;
    }

    @Override
    public Boolean isLineTerminator() {
        return this.getType() == 5 && this.getLexeme().length() == 1 && CharUtils.isNewLine(this.getLexeme().codePointAt(0));
    }

    @Override
    public Boolean isStatementSeparator() {
        return this.getType() == 5 && this.getLexeme().length() == 1 && this.getLexeme().codePointAt(0) == 58;
    }
}

