/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors.commands;

import com.scriptbasic.api.ScriptBasicException;
import com.scriptbasic.executors.commands.AbstractCommandSelectPart;
import com.scriptbasic.executors.commands.CommandEndSelect;
import com.scriptbasic.executors.operators.RightSideEqualsOperator;
import com.scriptbasic.executors.operators.RightSideGreaterOrEqualOperator;
import com.scriptbasic.executors.operators.RightSideLessOrEqualOperator;
import com.scriptbasic.executors.rightvalues.AbstractPrimitiveRightValue;
import com.scriptbasic.executors.rightvalues.BasicBooleanValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.Expression;
import com.scriptbasic.spi.Interpreter;
import com.scriptbasic.spi.RightValue;
import java.util.ArrayList;
import java.util.List;

public class CommandCase
extends AbstractCommandSelectPart {
    private final List<CaseCondition> expressionList = new ArrayList<CaseCondition>();
    private CommandEndSelect commandEndSelect;

    @Override
    public void execute(Interpreter interpreter) {
        Boolean caseApplied = (Boolean)interpreter.getMap().get("SELECT_CASE_APPLIED");
        if (caseApplied.booleanValue()) {
            interpreter.setNextCommand(this.commandEndSelect);
        } else {
            interpreter.getMap().put("SELECT_CASE_APPLIED", true);
            interpreter.setNextCommand(this.getNextCommand());
        }
    }

    public void addCaseCondition(CaseCondition caseCondition) {
        this.expressionList.add(caseCondition);
    }

    public boolean matches(Interpreter interpreter, RightValue expressionValue) throws ScriptBasicException {
        if (this.expressionList.size() == 0) {
            return true;
        }
        for (CaseCondition caseCondition : this.expressionList) {
            if (!caseCondition.matchCase(interpreter, expressionValue)) continue;
            return true;
        }
        return false;
    }

    public void addCaseEqualCondition(Expression expression) {
        EqualCaseCondition caseCondition = new EqualCaseCondition(expression);
        this.addCaseCondition(caseCondition);
    }

    public void addCaseFromToCondition(Expression fromExpression, Expression toExpression) {
        FromToCaseCondition caseCondition = new FromToCaseCondition(fromExpression, toExpression);
        this.addCaseCondition(caseCondition);
    }

    public void setEndSelect(CommandEndSelect commandEndSelect) {
        this.commandEndSelect = commandEndSelect;
    }

    public static interface CaseCondition {
        public boolean matchCase(Interpreter var1, RightValue var2) throws ScriptBasicException;
    }

    public static class EqualCaseCondition
    implements CaseCondition {
        final Expression expression;

        public EqualCaseCondition(Expression expression) {
            this.expression = expression;
        }

        @Override
        public boolean matchCase(Interpreter interpreter, RightValue selectExpressionValue) throws ScriptBasicException {
            RightSideEqualsOperator operator = new RightSideEqualsOperator(selectExpressionValue);
            operator.setRightOperand(this.expression);
            RightValue conditionValue = operator.evaluate(interpreter);
            if (conditionValue instanceof AbstractPrimitiveRightValue) {
                return BasicBooleanValue.asBoolean(conditionValue);
            }
            throw new BasicRuntimeException("Case condition can not be evaluated to boolean");
        }
    }

    public static class FromToCaseCondition
    implements CaseCondition {
        private final Expression fromExpression;
        private final Expression toExpression;

        public FromToCaseCondition(Expression fromExpression, Expression toExpression) {
            this.fromExpression = fromExpression;
            this.toExpression = toExpression;
        }

        @Override
        public boolean matchCase(Interpreter interpreter, RightValue selectExpressionValue) throws ScriptBasicException {
            RightSideGreaterOrEqualOperator leftOperator = new RightSideGreaterOrEqualOperator(selectExpressionValue);
            leftOperator.setRightOperand(this.fromExpression);
            RightValue conditionValue = leftOperator.evaluate(interpreter);
            if (conditionValue instanceof AbstractPrimitiveRightValue) {
                if (!BasicBooleanValue.asBoolean(conditionValue).booleanValue()) {
                    return false;
                }
                RightSideLessOrEqualOperator rightOperator = new RightSideLessOrEqualOperator(selectExpressionValue);
                rightOperator.setRightOperand(this.toExpression);
                conditionValue = rightOperator.evaluate(interpreter);
                if (conditionValue instanceof AbstractPrimitiveRightValue) {
                    return BasicBooleanValue.asBoolean(conditionValue);
                }
            }
            throw new BasicRuntimeException("Case condition can not be evaluated to boolean");
        }
    }
}

