/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors;

import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.MethodRegistry;
import com.scriptbasic.spi.Interpreter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class BasicMethodRegistry
implements MethodRegistry {
    private final Map<String, RegistryItem> registry = new HashMap<String, RegistryItem>();
    private final Map<String, RegistryItem> globalRegistry = new HashMap<String, RegistryItem>();

    private static String formKey(String alias, Class<?> klass) {
        return alias + "#" + klass.getName().replaceAll("\\$", ".");
    }

    @Override
    public Method getJavaMethod(Class<?> klass, String alias) {
        Method method;
        RegistryItem item = this.getRegistryItem(klass, alias);
        if (item == null) {
            method = null;
        } else if (item.method == null) {
            Class[] args = new Class[item.args.length + 1];
            args[0] = Interpreter.class;
            System.arraycopy(item.args, 0, args, 1, item.args.length);
            method = Optional.ofNullable(this.getMethod(item.klass, item.methodName, args)).orElseGet(() -> this.getMethod(item.klass, item.methodName, item.args));
        } else {
            method = item.method;
        }
        return method;
    }

    private RegistryItem getRegistryItem(Class<?> klass, String alias) {
        RegistryItem item = klass == null ? this.globalRegistry.get(alias) : this.registry.get(BasicMethodRegistry.formKey(alias, klass));
        return item;
    }

    private Method getMethod(Class<?> klass, String methodName, Class<?>[] args) {
        try {
            return klass.getMethod(methodName, args);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private boolean definitionIsTheSame(RegistryItem a, RegistryItem b) {
        return a.methodName.equals(b.methodName) && a.klass.equals(b.klass) && Arrays.equals(a.args, b.args);
    }

    private void registerGlobal(String alias, RegistryItem item) throws BasicRuntimeException {
        if (this.globalRegistry.containsKey(alias) && !this.definitionIsTheSame(this.globalRegistry.get(alias), item)) {
            throw new BasicRuntimeException("The BASIC function alias '" + alias + " can not be defined to point to the Java method '" + item.toString() + " because it is already defined to be " + this.globalRegistry.get(alias).toString());
        }
        this.globalRegistry.put(alias, item);
    }

    @Override
    public void registerJavaMethod(String alias, Class<?> klass, String methodName, Class<?>[] argumentTypes) throws BasicRuntimeException {
        String aliasLowerCase = alias.toLowerCase();
        RegistryItem item = new RegistryItem();
        item.methodName = methodName;
        item.klass = klass;
        item.args = (Class[])argumentTypes.clone();
        this.registry.put(BasicMethodRegistry.formKey(aliasLowerCase, klass), item);
        this.registerGlobal(aliasLowerCase, item);
    }

    private static class RegistryItem {
        private final Method method = null;
        private String methodName;
        private Class<?> klass;
        private Class<?>[] args;

        private RegistryItem() {
        }

        public String toString() {
            return this.klass + "." + this.methodName + "(" + Arrays.stream(this.args).map(Class::getName).collect(Collectors.joining(",")) + ")";
        }
    }
}

