/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.ruby;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Optional;
import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.Identified;
import javax0.jamal.api.Processor;
import javax0.jamal.tools.InputHandler;
import javax0.jamal.tools.MacroReader;
import org.jruby.embed.ScriptingContainer;

public class Shell
implements Identified {
    private final String id;
    final ScriptingContainer shell;
    public static final String DEFAULT_RUBY_SHELL_NAME = ":rubyShell";
    public static final String RUBY_SHELL_NAMING_MACRO = "rubyShell";

    public void property(String key, Object value) {
        this.shell.put(key, value);
    }

    public Object property(String key) {
        return this.shell.get(key);
    }

    public Shell(String id) {
        this.id = id;
        this.shell = new ScriptingContainer();
        this.shell.setError((Writer)new StringWriter(){

            @Override
            public void write(char[] cbuf, int off, int len) {
            }
        });
    }

    public Object evaluate(String script, String fileName) {
        if (fileName != null && fileName.length() > 0) {
            return this.shell.runScriptlet((Reader)new StringReader(script), fileName);
        }
        return this.shell.runScriptlet((Reader)new StringReader(script), this.id + ".rb");
    }

    public String getId() {
        return this.id;
    }

    public static Shell getShell(Processor processor) throws BadSyntax {
        String id = MacroReader.macro((Processor)processor).readValue(RUBY_SHELL_NAMING_MACRO).orElse(DEFAULT_RUBY_SHELL_NAME);
        return Shell.getShell(processor, id);
    }

    public static Shell getShell(Processor processor, String id) throws BadSyntax {
        Shell shell;
        Optional<Identified> opt = processor.getRegister().getUserDefined(id).filter(s -> s instanceof Shell);
        if (opt.isEmpty()) {
            String gid = InputHandler.convertGlobal((String)id);
            shell = new Shell(gid);
            if (InputHandler.isGlobalMacro((String)id)) {
                processor.defineGlobal((Identified)shell);
            } else {
                processor.define((Identified)shell);
                processor.getRegister().export(shell.getId());
            }
        } else {
            shell = (Shell)opt.get();
        }
        return shell;
    }
}

