/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.ruby;

import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.InnerScopeDependent;
import javax0.jamal.api.Input;
import javax0.jamal.api.Macro;
import javax0.jamal.api.Processor;
import javax0.jamal.ruby.Shell;
import javax0.jamal.tools.InputHandler;
import org.jruby.Ruby;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyProperty
implements Macro,
InnerScopeDependent {
    private static final String FLOAT_REGEX = "[-+]?[0-9]*\\.?[0-9]+(?:[eE][-+]?[0-9]+)?";
    private static final String INT_REGEX = "[-+]?[0-9]*";
    private static final Pattern FLOAT_PATTERN = Pattern.compile("([-+]?[0-9]*\\.?[0-9]+(?:[eE][-+]?[0-9]+)?)\\s*\\+\\s*([-+]?[0-9]*\\.?[0-9]+(?:[eE][-+]?[0-9]+)?)\\s*i");
    private static final Pattern INT_PATTERN = Pattern.compile("([-+]?[0-9]*)\\s*\\+\\s*([-+]?[0-9]*)\\s*i");

    public String evaluate(Input in, Processor processor) throws BadSyntax {
        Shell shell = Shell.getShell(processor);
        InputHandler.skipWhiteSpaces((Input)in);
        String id = InputHandler.fetchId((Input)in);
        InputHandler.skipWhiteSpaces((Input)in);
        if (in.length() == 0) {
            return "" + shell.property(id);
        }
        if (!InputHandler.firstCharIs((CharSequence)in, (char[])new char[]{'='})) {
            throw new BadSyntax("There must be a '=' after the name of the Ruby property to assign a value to it.");
        }
        InputHandler.skip((Input)in, (int)1);
        InputHandler.skipWhiteSpaces((Input)in);
        shell.property(id, RubyProperty.cast(in.toString(), shell.shell.getProvider().getRuntime()));
        return "";
    }

    private static Object cast(String s, Ruby ruby) throws BadSyntax {
        try {
            return RubyProperty.cast(s, "to_sym", k -> RubySymbol.newSymbol((Ruby)ruby, (String)k)).orElseGet(() -> RubyProperty.cast(s, "to_r", k -> RubyProperty.toRational(ruby, k)).orElseGet(() -> RubyProperty.cast(s, "to_f", k -> RubyFloat.newFloat((Ruby)ruby, (double)Double.parseDouble(k))).orElseGet(() -> RubyProperty.cast(s, "to_i", k -> RubyFixnum.newFixnum((Ruby)ruby, (long)Long.parseLong(k))).orElseGet(() -> RubyProperty.cast(s, "to_c", k -> RubyProperty.toComplex(ruby, k)).orElseGet(() -> RubyProperty.cast(s, "to_c/i", k -> RubyProperty.toComplexInt(ruby, k)).orElseGet(() -> RubyProperty.cast(s, "to_s", k -> RubyString.newString((Ruby)ruby, (String)k)).orElseGet(() -> RubyString.newString((Ruby)ruby, (String)s))))))));
        }
        catch (Exception e) {
            throw new BadSyntax("There was an error during casting the value '" + s + "'", (Throwable)e);
        }
    }

    private static RubyRational toRational(Ruby ruby, String s) {
        String[] parts = s.split("/", -1);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Ruby rational has to be 'number / number' format and '" + s + "' is not.");
        }
        return RubyRational.newRational((Ruby)ruby, (long)Long.parseLong(parts[0].trim()), (long)Long.parseLong(parts[1].trim()));
    }

    private static RubyComplex toComplex(Ruby ruby, String s) {
        Matcher matcher = FLOAT_PATTERN.matcher(s);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Ruby complex has to be 'R+Ci' format and '" + s + "' is not.");
        }
        return RubyComplex.newComplexRaw((Ruby)ruby, (IRubyObject)RubyFloat.newFloat((Ruby)ruby, (double)Double.parseDouble(matcher.group(1))), (IRubyObject)RubyFloat.newFloat((Ruby)ruby, (double)Double.parseDouble(matcher.group(2))));
    }

    private static RubyComplex toComplexInt(Ruby ruby, String s) {
        Matcher matcher = INT_PATTERN.matcher(s);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Ruby complex has to be 'R+Ci' format and '" + s + "' is not.");
        }
        return RubyComplex.newComplexRaw((Ruby)ruby, (IRubyObject)RubyFixnum.newFixnum((Ruby)ruby, (long)Long.parseLong(matcher.group(1))), (IRubyObject)RubyFixnum.newFixnum((Ruby)ruby, (long)Long.parseLong(matcher.group(2))));
    }

    private static Optional<Object> cast(String s, String prefix, Function<String, Object> converter) {
        if (s.startsWith((String)(prefix = "(" + (String)prefix + ")"))) {
            return Optional.of(converter.apply(s.substring(((String)prefix).length()).replaceAll("^\\s*", "")));
        }
        return Optional.empty();
    }

    public String getId() {
        return "ruby:property";
    }
}

