/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.ruby;

import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.Closer;
import javax0.jamal.api.InnerScopeDependent;
import javax0.jamal.api.Input;
import javax0.jamal.api.Macro;
import javax0.jamal.api.Processor;
import javax0.jamal.ruby.Shell;
import org.jruby.Ruby;
import org.jruby.RubyString;

public class RubyCloser
implements Macro,
InnerScopeDependent {
    public String evaluate(Input in, Processor processor) throws BadSyntax {
        Shell shell = Shell.getShell(processor);
        Closer closer = new Closer(shell, in.toString());
        processor.deferredClose((AutoCloseable)closer);
        return "";
    }

    public String getId() {
        return "ruby:closer";
    }

    private static class Closer
    implements AutoCloseable,
    Closer.OutputAware {
        private Input result;
        private final Shell shell;
        private final String closerScript;

        private Closer(Shell shell, String closerScript) {
            this.shell = shell;
            this.closerScript = closerScript;
        }

        @Override
        public void close() throws Exception {
            this.shell.property("$result", RubyString.newString((Ruby)this.shell.shell.getProvider().getRuntime(), (CharSequence)this.result.getSB()));
            try {
                Object sb = this.shell.evaluate(this.closerScript, null);
                if (sb == null) {
                    throw new BadSyntax("Ruby closer script '" + this.shell.getId() + "' returned null");
                }
                this.result.getSB().delete(0, this.result.getSB().length());
                this.result.getSB().append(sb.toString());
            }
            catch (Exception e) {
                throw new BadSyntax("There was an exception '" + e.getMessage() + "' executing the ruby closer script in the shell '" + this.shell.getId() + "'.", (Throwable)e);
            }
        }

        public void set(Input result) {
            this.result = result;
        }
    }
}

