/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.plantuml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.InnerScopeDependent;
import javax0.jamal.api.Input;
import javax0.jamal.api.Macro;
import javax0.jamal.api.Processor;
import javax0.jamal.tools.Cache;
import javax0.jamal.tools.FileTools;
import javax0.jamal.tools.InputHandler;
import javax0.jamal.tools.MacroReader;
import javax0.jamal.tools.PlaceHolders;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;

public class PlantUml
implements Macro,
InnerScopeDependent {
    public String evaluate(Input in, Processor processor) throws BadSyntax {
        MacroReader macroReader = MacroReader.macro((Processor)processor);
        String root = macroReader.readValue("pu$folder").map(s -> s.endsWith("/") ? s : s + "/").orElse("");
        String format = macroReader.readValue("pu$format").orElse("SVG");
        String template = macroReader.readValue("pu$template").orElse("$file");
        String fileName = InputHandler.fetch2EOL((Input)in).trim();
        String absoluteFileName = FileTools.absolute((String)in.getReference(), (String)(root + fileName));
        InputHandler.skipWhiteSpaces((Input)in);
        String umlText = this.getUmlText(in);
        File output = new File(absoluteFileName).getAbsoluteFile();
        Cache.Entry entry = this.getCacheEntry(output);
        try {
            boolean erred;
            if (this.needPlantUmlRun(umlText, output, entry)) {
                erred = this.convertToFile(umlText, output, format);
                if (entry != null) {
                    entry.save(umlText, new Map[]{Map.of("error", "" + erred)});
                }
            } else {
                erred = "true".equals(entry.getProperty("error"));
            }
            if (erred) {
                throw new BadSyntax("There was an error processing diagram for '" + fileName + "' in PlantUml.");
            }
            return PlaceHolders.with((String)"$file", (String)fileName).format(template);
        }
        catch (Exception e) {
            throw new BadSyntax("PlantUml diagram '" + fileName + "'cannot be created.", (Throwable)e);
        }
    }

    private boolean convertToFile(String text, File file, String format) throws BadSyntax, IOException {
        boolean erred;
        ByteArrayOutputStream os;
        SourceStringReader reader = new SourceStringReader(text);
        FileFormat fileFormat = this.convertFileFormat(format);
        try (ByteArrayOutputStream byteArrayOutputStream = os = new ByteArrayOutputStream();){
            erred = "(Error)".equals(reader.outputImage((OutputStream)os, new FileFormatOption(fileFormat)).getDescription());
        }
        file.getParentFile().mkdirs();
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(os.toByteArray());
        }
        return erred;
    }

    private boolean needPlantUmlRun(String umlText, File output, Cache.Entry entry) {
        return entry == null || entry.isMiss() || !entry.getContent().toString().equals(umlText) || !output.exists();
    }

    private Cache.Entry getCacheEntry(File output) {
        try {
            return Cache.getEntry((URL)output.toURI().toURL());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private FileFormat convertFileFormat(String format) throws BadSyntax {
        for (FileFormat fileFormat : FileFormat.values()) {
            if (!format.equals(fileFormat.toString())) continue;
            return fileFormat;
        }
        throw new BadSyntax("The output format '" + format + "' is not supported by PlantUml.");
    }

    private String getUmlText(Input in) {
        Object umlText = in.toString();
        if (((String)umlText).length() > 0 && ((String)umlText).charAt(0) != '@') {
            umlText = "@startuml\n" + (String)umlText + "@enduml\n";
        }
        return umlText;
    }
}

