/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.tracer;

import java.util.ArrayList;
import java.util.List;
import javax0.jamal.api.Position;
import javax0.jamal.tracer.TraceRecord;
import javax0.jamal.tracer.TraceRecordFactory;

public class TraceRecordReal
implements TraceRecord {
    private final int level;
    private final StringBuilder before = new StringBuilder();
    private final StringBuilder evaluated = new StringBuilder();
    private final StringBuilder result = new StringBuilder();
    private final List<TraceRecord> subRecords = new ArrayList<TraceRecord>();
    private final List<String> warnings = new ArrayList<String>();
    private final TraceRecordFactory myFactory;
    private Position position;
    private TraceRecord.Type type;
    private boolean hasOutput = false;
    private String id = "";
    private String[] parameters;

    @Override
    public String[] getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(String[] parameters) {
        this.parameters = parameters;
    }

    public TraceRecordReal(int level, TraceRecordFactory myFactory) {
        this.level = level;
        this.myFactory = myFactory;
    }

    @Override
    public void close() {
        this.myFactory.pop();
    }

    @Override
    public TraceRecordReal appendBeforeState(String string) {
        this.before.append(string);
        return this;
    }

    @Override
    public TraceRecord appendAfterEvaluation(String string) {
        this.evaluated.append(string);
        return this;
    }

    @Override
    public TraceRecordReal appendResultState(String string) {
        this.result.append(string);
        this.hasOutput = true;
        return this;
    }

    @Override
    public TraceRecord subRecord(TraceRecord.Type type) {
        TraceRecordReal record = new TraceRecordReal(this.level + 1, this.myFactory);
        this.subRecords.add(record);
        return record;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        if (id != null) {
            this.id = id;
        }
    }

    @Override
    public List<TraceRecord> getSubRecords() {
        return this.subRecords;
    }

    @Override
    public String beforeState() {
        return this.before.toString();
    }

    @Override
    public String evaluatedState() {
        return this.evaluated.toString();
    }

    @Override
    public String resultState() {
        return this.result.toString();
    }

    @Override
    public int level() {
        return this.level;
    }

    @Override
    public Position position() {
        return this.position;
    }

    @Override
    public void position(Position position) {
        this.position = position;
    }

    @Override
    public TraceRecord.Type type() {
        return this.type;
    }

    @Override
    public void type(TraceRecord.Type type) {
        this.type = type;
    }

    @Override
    public void warning(String s) {
        this.warnings.add(s);
    }

    @Override
    public List<String> getWarnings() {
        return this.warnings;
    }

    @Override
    public boolean hasOutput() {
        return this.hasOutput;
    }
}

