/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.tracer;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import javax0.jamal.api.Position;
import javax0.jamal.tracer.TraceDumper;
import javax0.jamal.tracer.TraceRecord;
import javax0.jamal.tracer.TraceRecordNull;
import javax0.jamal.tracer.TraceRecordReal;

public class TraceRecordFactory {
    final List<TraceRecord> traces = new ArrayList<TraceRecord>();
    final Deque<TraceRecord> stack = new ArrayDeque<TraceRecord>();
    private static final String JAMAL_TRACE_ENV = "JAMAL_TRACE";
    private static final String JAMAL_TRACE_SYS = "jamal.trace";
    private final String traceFile;
    private int level = 0;

    public TraceRecordFactory() {
        String sysProp = System.getProperty(JAMAL_TRACE_SYS);
        this.traceFile = sysProp != null ? sysProp : System.getenv(JAMAL_TRACE_ENV);
    }

    public TraceRecord openUserDefinedMacroRecord(Position position) {
        TraceRecord record = this.openTraceRecord(position, TraceRecord.Type.USER_DEFINED_MACRO);
        record.type(TraceRecord.Type.USER_DEFINED_MACRO);
        return record;
    }

    public TraceRecord openMacroRecord(Position position) {
        TraceRecord record = this.openTraceRecord(position, TraceRecord.Type.MACRO);
        record.type(TraceRecord.Type.MACRO);
        return record;
    }

    public TraceRecord openTextRecord(Position position) {
        return this.openTraceRecord(position, TraceRecord.Type.TEXT);
    }

    private TraceRecord openTraceRecord(Position position, TraceRecord.Type t) {
        if (this.traceFile == null) {
            return new TraceRecordNull();
        }
        ++this.level;
        TraceRecord traceRecord = this.stack.isEmpty() ? new TraceRecordReal(this.level, this) : this.stack.getLast().subRecord(t);
        if (this.stack.isEmpty()) {
            this.traces.add(traceRecord);
        }
        this.stack.add(traceRecord);
        traceRecord.type(t);
        traceRecord.position(position);
        return traceRecord;
    }

    void pop() {
        --this.level;
        this.stack.removeLast();
    }

    public void dump(Exception ex) {
        if (this.level == 0 && this.traceFile != null) {
            new TraceDumper().dump(this.traces, this.traceFile, ex);
        }
    }
}

