/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.engine.util;

public class SeparatorCalculator {
    final String chars;
    private final Layer top;
    private static final int N = 100;
    private static final int INCREMENT = 10;
    private Layer[] layers;

    public SeparatorCalculator(String chars) {
        this.chars = chars;
        this.top = new Layer(chars.length());
    }

    public String calculate(String input) {
        this.layers = new Layer[Math.min(100, input.length())];
        this.buildUpTrieFromInput(input);
        return this.getShort(this.top);
    }

    private void buildUpTrieFromInput(String input) {
        int currentLevel = -1;
        for (char ch : input.toCharArray()) {
            int index = this.chars.indexOf(ch);
            if (index == -1) {
                currentLevel = -1;
                continue;
            }
            currentLevel = this.safelyIncreaseCurrentLevel(currentLevel);
            this.layers[currentLevel] = this.top;
            this.appendInAllLayers(currentLevel, index);
        }
    }

    private int safelyIncreaseCurrentLevel(int currentLevel) {
        if (++currentLevel == this.layers.length) {
            this.resizeLayers();
        }
        return currentLevel;
    }

    private void appendInAllLayers(int currentLevel, int index) {
        for (int i = currentLevel; i >= 0; --i) {
            if (this.layers[i].nodes[index] == null) {
                this.layers[i].nodes[index] = new Layer(this.chars.length());
            }
            this.layers[i] = this.layers[i].nodes[index];
        }
    }

    private String getShort(Layer layer) {
        for (int i = 0; i < layer.nodes.length; ++i) {
            if (layer.nodes[i] != null) continue;
            return this.chars.substring(i, i + 1);
        }
        int min = Integer.MAX_VALUE;
        String minString = "";
        int minIndex = 0;
        for (int i = 0; i < layer.nodes.length; ++i) {
            String s = this.getShort(layer.nodes[i]);
            if (s.length() >= min) continue;
            min = s.length();
            minString = s;
            minIndex = i;
            if (min != 1) continue;
            return this.chars.charAt(i) + minString;
        }
        return this.chars.charAt(minIndex) + minString;
    }

    private void resizeLayers() {
        Layer[] array = new Layer[this.layers.length + 10];
        System.arraycopy(this.layers, 0, array, 0, this.layers.length);
        this.layers = array;
    }

    private static final class Layer {
        private final Layer[] nodes;

        private Layer(int size) {
            this.nodes = new Layer[size];
        }
    }
}

