/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.engine.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Replacer {
    private final Map<String, String> map;
    private final String openStr;
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("\\s*(@|#)\\s*escape\\s*(`.*?`).*?\\2\\s*");
    private final StringBuilder sb = new StringBuilder();
    private String key;
    private String value;
    private int from;

    public Replacer(Map<String, String> map, String openStr) {
        this.map = map;
        this.openStr = openStr;
    }

    public String replace(String input) {
        this.sb.delete(0, this.sb.length());
        this.sb.append(input);
        int loc = 0;
        while (this.find(loc)) {
            loc = this.replace();
        }
        return this.sb.toString();
    }

    private int replace() {
        Matcher matcher;
        this.sb.replace(this.from, this.from + this.key.length(), this.value);
        if (this.key.equals(this.openStr) && (matcher = ESCAPE_PATTERN.matcher(this.sb.substring(this.from + this.value.length()))).find() && matcher.start() == 0) {
            return this.from + this.value.length() + matcher.end();
        }
        return this.from + this.value.length();
    }

    private boolean find(int start) {
        int min = this.sb.length();
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            int index = this.sb.toString().indexOf(entry.getKey(), start);
            if ((index <= -1 || index >= min) && (index != min || entry.getKey().length() <= this.key.length())) continue;
            this.key = entry.getKey();
            this.value = entry.getValue();
            this.from = index;
            min = index;
        }
        return min < this.sb.length();
    }
}

