/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.engine.util;

import java.util.Optional;
import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.BadSyntaxAt;
import javax0.jamal.api.Evaluable;
import javax0.jamal.api.InnerScopeDependent;
import javax0.jamal.api.Input;
import javax0.jamal.api.Macro;
import javax0.jamal.api.Position;
import javax0.jamal.engine.Processor;
import javax0.jamal.tools.InputHandler;
import javax0.jamal.tools.OptionsStore;

public class MacroQualifier {
    public final Input input;
    public String macroId;
    public Evaluable udMacro;
    public final boolean isVerbatim;
    public final boolean isBuiltIn;
    public final Macro macro;
    public final boolean oldStyle;
    public int postEvalCount;
    public final Processor processor;
    private final String NOT_USED;

    public MacroQualifier(Processor processor, Input input, int postEvalCount) throws BadSyntax {
        this.NOT_USED = null;
        this.processor = processor;
        this.input = input;
        this.postEvalCount = postEvalCount;
        this.oldStyle = OptionsStore.getInstance((javax0.jamal.api.Processor)processor).is("omasalgotm");
        if (this.macroIsBuiltIn(input)) {
            InputHandler.skip((Input)input, (int)1);
            InputHandler.skipWhiteSpaces((Input)input);
            this.macroId = InputHandler.fetchId((Input)input);
            this.isVerbatim = "verbatim".equals(this.macroId);
            boolean bl = this.isBuiltIn = !this.isVerbatim;
            if (this.isVerbatim) {
                InputHandler.skipWhiteSpaces((Input)input);
            }
        } else {
            this.isBuiltIn = false;
            this.isVerbatim = false;
            this.macroId = this.NOT_USED;
        }
        this.macro = this.getMacro(this.macroId, input.getPosition(), this.isBuiltIn);
    }

    private boolean macroIsBuiltIn(Input input) {
        return input.length() > 0 && (input.charAt(0) == '#' || input.charAt(0) == '@');
    }

    private Macro getMacro(String macroId, Position pos, boolean isBuiltIn) throws BadSyntaxAt {
        if (isBuiltIn) {
            Optional optMacro = this.processor.getRegister().getMacro(macroId);
            if (optMacro.isEmpty()) {
                throw new BadSyntaxAt("There is no built-in macro with the id '" + macroId + "'", pos);
            }
            return (Macro)optMacro.get();
        }
        return null;
    }

    public boolean isInnerScopeDependent() {
        return this.macro instanceof InnerScopeDependent;
    }
}

