/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.engine.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;
import javax0.jamal.api.BadSyntaxAt;
import javax0.jamal.api.Position;

public class ExceptionDumper {
    final StringBuilder output = new StringBuilder();
    final Set<Throwable> processed = new HashSet<Throwable>();

    public static StringBuilder dump(BadSyntaxAt t) {
        ExceptionDumper me = new ExceptionDumper();
        Position pos = t.getPosition();
        me.output.append(t.getMessage()).append(" at ").append(pos.file).append("/").append(pos.line).append(":").append(pos.column).append("\n");
        me.dumpIt((Throwable)t, false);
        return me.output;
    }

    private void dumpIt(Throwable t, boolean printMessage) {
        if (t == null || this.processed.contains(t)) {
            return;
        }
        this.processed.add(t);
        if (printMessage) {
            this.output.append(t.getMessage());
        }
        try (StringWriter sw = new StringWriter();
             PrintWriter pw = new PrintWriter(sw);){
            t.printStackTrace(pw);
            this.output.append(sw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (t.getSuppressed().length > 0) {
            this.output.append("Suppressed exceptions:\n");
            for (Throwable sup : t.getSuppressed()) {
                this.dumpIt(sup, true);
            }
        }
        if (t.getCause() != null) {
            this.output.append("Causing Exception:\n");
            this.dumpIt(t.getCause(), true);
        }
    }
}

