/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.engine.macro;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.BadSyntaxAt;
import javax0.jamal.api.Debuggable;
import javax0.jamal.api.Identified;
import javax0.jamal.api.Macro;
import javax0.jamal.api.Marker;
import javax0.jamal.api.Stackable;
import javax0.jamal.engine.Delimiters;
import javax0.jamal.tools.InputHandler;

public class MacroRegister
implements javax0.jamal.api.MacroRegister,
Debuggable.MacroRegister {
    private static final int TOP_LEVEL = 0;
    private final List<Scope> scopeStack = new ArrayList<Scope>();
    private final List<Marker> poppedMarkers = new ArrayList<Marker>();

    public Optional<Debuggable.MacroRegister> debuggable() {
        return Optional.of(this);
    }

    public List<Marker> getPoppedMarkers() {
        return this.poppedMarkers;
    }

    public List<Debuggable.Scope> getScopes() {
        return this.scopeStack;
    }

    public MacroRegister() {
        try {
            this.push(null);
        }
        catch (BadSyntax badSyntax) {
            throw new RuntimeException("SNAFU: should not happen");
        }
    }

    private Scope currentScope() {
        return this.scopeStack.get(this.scopeStack.size() - 1);
    }

    private int writableOffset() {
        return this.currentScope().locked ? 2 : 1;
    }

    private Scope writableScope() {
        return this.scopeStack.get(this.scopeStack.size() - this.writableOffset());
    }

    private <T> Optional<T> stackGet(Function<Scope, Map<String, T>> field, String id) {
        int end = this.scopeStack.size() - 1;
        return IntStream.range(0, this.scopeStack.size()).sequential().mapToObj(i -> this.scopeStack.get(end - i)).map(field).filter(map -> map.containsKey(id)).map(map -> map.get(id)).findFirst();
    }

    public <T extends Identified> Optional<T> getUserDefined(String id) {
        Objects.requireNonNull(id);
        if (InputHandler.isGlobalMacro((String)id)) {
            return Optional.ofNullable(this.scopeStack.get((int)0).udMacros.get(InputHandler.convertGlobal((String)id)));
        }
        return this.stackGet(Scope::getUdMacros, id);
    }

    public Optional<Macro> getMacro(String id) {
        if (InputHandler.isGlobalMacro((String)id)) {
            return Optional.ofNullable(this.scopeStack.get((int)0).macros.get(InputHandler.convertGlobal((String)id)));
        }
        return this.stackGet(Scope::getMacros, id);
    }

    public void global(Identified macro) {
        this.scopeStack.get((int)0).udMacros.put(macro.getId(), macro);
    }

    public void global(Macro macro) {
        this.scopeStack.get((int)0).macros.put(macro.getId(), macro);
    }

    public void global(Macro macro, String alias) {
        this.scopeStack.get((int)0).macros.put(alias, macro);
    }

    public void define(Identified macro) {
        this.writableScope().udMacros.put(macro.getId(), macro);
    }

    public void define(Macro macro) {
        this.define(macro, macro.getId());
    }

    public void define(Macro macro, String alias) {
        this.writableScope().macros.put(alias, macro);
    }

    public void export(String id) throws BadSyntax {
        Identified macro;
        if (this.scopeStack.size() > this.writableOffset()) {
            macro = this.writableScope().udMacros.get(id);
            if (macro == null) {
                throw new BadSyntax("Macro '" + id + "' cannot be exported, not in the scope of export.");
            }
        } else {
            throw new BadSyntax("Macro '" + id + "' cannot be exported from the top level");
        }
        this.scopeStack.get((int)(this.scopeStack.size() - this.writableOffset() - 1)).udMacros.put(id, macro);
        this.writableScope().udMacros.remove(id);
    }

    private void stack(Macro macro, Consumer<Stackable> c) {
        if (macro instanceof Stackable) {
            c.accept((Stackable)macro);
        }
    }

    public void push(Marker check) throws BadSyntax {
        if (this.markerIsInTheStack(check)) {
            throw new BadSyntax("Push was performed using the marker " + check + " which happens to be already in the stack.");
        }
        Scope scope = new Scope(check);
        this.scopeStack.add(scope);
        this.scopeStack.forEach(scp -> scp.macros.values().forEach(macro -> this.stack((Macro)macro, Stackable::push)));
        scope.delimiterPair = new Delimiters();
        this.poppedMarkers.clear();
    }

    public Marker test() {
        return this.currentScope().checkObject;
    }

    public void test(Marker check) throws BadSyntax {
        if (this.scopeStack.size() > 1) {
            Scope current = this.currentScope();
            if (!Objects.equals(check, current.checkObject)) {
                if (this.markerIsInTheStack(check)) {
                    this.tryCleanUpStack(check);
                }
                throw new BadSyntaxAt("Scope was changed from " + check + " to " + current.checkObject + " and it was not closed before the end.", current.checkObject.getPosition());
            }
        } else if (check != null) {
            throw new BadSyntax("Scope opened with " + check + " was closed immature.");
        }
    }

    public void pop(Marker check) throws BadSyntax {
        if (this.scopeStack.size() > 1) {
            Scope current = this.currentScope();
            if (!Objects.equals(check, current.checkObject)) {
                if (this.markerIsInTheStack(check)) {
                    this.tryCleanUpStack(check);
                    this.popStackOneLevel();
                }
                throw new BadSyntax("Pop was performed by " + check + " for a level pushed by " + current.checkObject);
            }
        } else {
            throw new BadSyntax("Cannot close the top level scope.");
        }
        this.popStackOneLevel();
    }

    private boolean markerIsInTheStack(Marker check) {
        for (Scope scopeWalker : this.scopeStack) {
            if (!Objects.equals(check, scopeWalker.checkObject)) continue;
            return true;
        }
        return false;
    }

    private void tryCleanUpStack(Marker check) throws BadSyntax {
        while (this.scopeStack.size() > 0 && !Objects.equals(check, this.currentScope().checkObject)) {
            this.popStackOneLevel();
        }
    }

    private void popStackOneLevel() throws BadSyntax {
        if (this.scopeStack.size() > 0) {
            Scope removedScope = this.scopeStack.remove(this.scopeStack.size() - 1);
            for (Macro macro : removedScope.getMacros().values()) {
                if (!(macro instanceof AutoCloseable)) continue;
                try {
                    ((AutoCloseable)macro).close();
                }
                catch (Exception e) {
                    throw new BadSyntax("Closing AutoCloseable macro '" + macro.getId() + "' caused exception.", (Throwable)e);
                }
            }
            for (Identified identified : removedScope.getUdMacros().values()) {
                if (!(identified instanceof AutoCloseable)) continue;
                try {
                    ((AutoCloseable)identified).close();
                }
                catch (Exception e) {
                    throw new BadSyntax("Closing AutoCloseable user defined macro '" + identified.getId() + "' caused exception.", (Throwable)e);
                }
            }
            this.poppedMarkers.add(removedScope.checkObject);
            this.scopeStack.forEach(scope -> scope.macros.values().forEach(macro -> this.stack((Macro)macro, Stackable::pop)));
        }
    }

    public void lock(Marker check) throws BadSyntax {
        if (this.scopeStack.size() > 1) {
            if (!Objects.equals(check, this.currentScope().checkObject)) {
                throw new BadSyntax("Lock was performed by " + check + " for a level pushed by " + this.currentScope().checkObject);
            }
        } else {
            throw new BadSyntax("Cannot lock the top level scope.");
        }
        this.currentScope().locked = true;
    }

    private String stackGet(Function<javax0.jamal.api.Delimiters, String> openOrClose) {
        int end = this.scopeStack.size() - 1;
        return IntStream.range(0, this.scopeStack.size()).sequential().mapToObj(i -> this.scopeStack.get(end - i)).map(scope -> scope.delimiterPair).map(openOrClose).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public String open() {
        return this.stackGet(javax0.jamal.api.Delimiters::open);
    }

    public String close() {
        return this.stackGet(javax0.jamal.api.Delimiters::close);
    }

    public void separators(String openDelimiter, String closeDelimiter) throws BadSyntax {
        javax0.jamal.api.Delimiters delimiterPair = this.currentScope().delimiterPair;
        List<javax0.jamal.api.Delimiters> savedList = this.currentScope().savedDelimiterPairs;
        if (openDelimiter == null || closeDelimiter == null) {
            if (savedList.size() == 0) {
                throw new BadSyntax("There was no saved macro start and end string to restore.");
            }
            javax0.jamal.api.Delimiters savedDelim = savedList.remove(savedList.size() - 1);
            delimiterPair.separators(savedDelim.open(), savedDelim.close());
        } else {
            Delimiters savedDelimiterPair = new Delimiters();
            savedDelimiterPair.separators(delimiterPair.open(), delimiterPair.close());
            savedList.add(savedDelimiterPair);
            delimiterPair.separators(openDelimiter, closeDelimiter);
        }
    }

    public static class Scope
    implements Debuggable.Scope {
        final Map<String, Identified> udMacros = new HashMap<String, Identified>();
        final Map<String, Macro> macros = new HashMap<String, Macro>();
        final List<javax0.jamal.api.Delimiters> savedDelimiterPairs = new ArrayList<javax0.jamal.api.Delimiters>();
        javax0.jamal.api.Delimiters delimiterPair = null;
        final Marker checkObject;
        boolean locked = false;

        public Map<String, Identified> getUdMacros() {
            return this.udMacros;
        }

        public Map<String, Macro> getMacros() {
            return this.macros;
        }

        public javax0.jamal.api.Delimiters getDelimiterPair() {
            return this.delimiterPair;
        }

        private Scope(Marker checkObject) {
            this.checkObject = checkObject;
        }
    }
}

