/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.engine.debugger;

import java.util.Optional;
import javax0.jamal.api.Debugger;
import javax0.jamal.engine.DebuggerStub;
import javax0.jamal.engine.NullDebugger;
import javax0.jamal.engine.Processor;

public class DebuggerFactory {
    public static Debugger build(Processor processor) {
        String s = Optional.ofNullable(System.getProperty("jamal.debug")).orElseGet(() -> System.getenv("JAMAL_DEBUG"));
        if (s == null || s.length() == 0) {
            return new NullDebugger();
        }
        int min = Integer.MAX_VALUE;
        boolean unique = true;
        Debugger selected = null;
        for (Debugger debugger : Debugger.getInstances()) {
            int affinity = debugger.affinity(s);
            if (affinity >= 0 && min > affinity) {
                unique = true;
                selected = debugger;
                min = affinity;
                continue;
            }
            if (min != affinity) continue;
            unique = false;
        }
        if (!unique) {
            throw new IllegalArgumentException("There are two or more equal minimum affinity debuggers.");
        }
        try {
            selected.init((Debugger.Stub)new DebuggerStub(processor));
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("There was an exception initializing the debugger.", e);
        }
        return selected;
    }
}

