/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.engine;

import java.util.Map;
import java.util.Optional;
import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.Configurable;
import javax0.jamal.api.Debuggable;
import javax0.jamal.api.Identified;
import javax0.jamal.engine.ArgumentHandler;
import javax0.jamal.engine.Processor;
import javax0.jamal.engine.macro.ParameterSegment;
import javax0.jamal.engine.macro.Segment;
import javax0.jamal.engine.macro.TextSegment;
import javax0.jamal.engine.util.Replacer;
import javax0.jamal.engine.util.SeparatorCalculator;
import javax0.jamal.tools.InputHandler;
import javax0.jamal.tools.OptionsStore;

public class UserDefinedMacro
implements javax0.jamal.api.UserDefinedMacro,
Configurable,
Debuggable.UserDefinedMacro {
    private static final String ESCAPE = "@escape ";
    private final String id;
    private final boolean verbatim;
    private final Processor processor;
    private final String content;
    private final ArgumentHandler argumentHandler;
    private final String openStr;
    private final String closeStr;
    private Segment root = null;
    private boolean pure = false;

    public Optional<Debuggable.UserDefinedMacro> debuggable() {
        return Optional.of(this);
    }

    public void configure(String key, Object object) {
        if ("pure".equals(key)) {
            this.pure = true;
        }
    }

    public UserDefinedMacro(Processor processor, String id, String content, boolean verbatim, String ... parameters) throws BadSyntax {
        this.processor = processor;
        this.openStr = processor.getRegister().open();
        this.closeStr = processor.getRegister().close();
        this.id = id;
        this.verbatim = verbatim;
        this.content = content;
        this.argumentHandler = new ArgumentHandler((Identified)this, parameters);
        InputHandler.ensure((String[])parameters, null);
    }

    public UserDefinedMacro(Processor processor, String id, String content, String ... parameters) throws BadSyntax {
        this(processor, id, content, false, parameters);
    }

    public boolean isVerbatim() {
        return this.verbatim;
    }

    public String getId() {
        return this.id;
    }

    private boolean isLenient() {
        return this.processor.option("lenient").isPresent();
    }

    public String evaluate(String ... parameters) throws BadSyntax {
        String[] adjustedValues = this.argumentHandler.adjustActualValues(parameters, this.isLenient());
        Map<String, String> values = this.argumentHandler.buildValueMap(adjustedValues);
        if (this.root == null) {
            this.root = this.createSegmentList();
        }
        StringBuilder output = new StringBuilder(this.segmentsLengthSum(this.root, values));
        String sep = this.pure || OptionsStore.getInstance((javax0.jamal.api.Processor)this.processor).is("omasalgotm") || this.openStr.equals(this.processor.getRegister().open()) && this.closeStr.equals(this.processor.getRegister().close()) ? null : "`" + new SeparatorCalculator("abcdefghijklmnopqsrtxvyz").calculate(this.processor.getRegister().open() + this.processor.getRegister().close()) + "`";
        for (Segment segment = this.root; segment != null; segment = segment.next()) {
            if (segment instanceof ParameterSegment) {
                output.append(segment.content(values));
                continue;
            }
            output.append(this.protect(segment.content(values), sep));
        }
        return output.toString();
    }

    private Segment createSegmentList() {
        TextSegment root = new TextSegment(null, this.content);
        for (int i = 0; i < this.argumentHandler.parameters.length; ++i) {
            for (Segment segment = root; segment != null; segment = segment.next()) {
                ((Segment)segment).split(this.argumentHandler.parameters[i]);
            }
        }
        if (root.content(null).length() == 0) {
            return root.next();
        }
        return root;
    }

    private int segmentsLengthSum(Segment root, Map<String, String> values) {
        int size = 0;
        for (Segment segment = root; segment != null; segment = segment.next()) {
            size += segment.content(values).length();
        }
        return size;
    }

    private String protect(String input, String sep) {
        if (sep != null) {
            String currOpen = this.processor.getRegister().open();
            String currClose = this.processor.getRegister().close();
            Replacer replacer = new Replacer(Map.of(currOpen, currOpen + ESCAPE + sep + currOpen + sep + currClose, currClose, currOpen + ESCAPE + sep + currClose + sep + currClose, this.openStr, currOpen, this.closeStr, currClose), this.openStr);
            return replacer.replace(input);
        }
        return input;
    }

    public int expectedNumberOfArguments() {
        if ("default".equals(this.getId()) && this.argumentHandler.parameters.length > 0 && ("$macro".equals(this.argumentHandler.parameters[0]) || "$_".equals(this.argumentHandler.parameters[0]))) {
            return this.argumentHandler.parameters.length - 1;
        }
        return this.argumentHandler.parameters.length;
    }

    public String[] getParameters() {
        return this.argumentHandler.parameters;
    }

    public String getContent() {
        return this.content;
    }

    public String getOpenStr() {
        return this.openStr;
    }

    public String getCloseStr() {
        return this.closeStr;
    }
}

