/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.engine;

import java.util.concurrent.atomic.AtomicInteger;
import javax0.jamal.api.BadSyntax;

public class StackLimiter {
    private static final int LIMIT = StackLimiter.getLimit();
    private static final String JAMAL_STACK_LIMIT = "JAMAL_STACK_LIMIT";
    private static final int DEFAULT_LIMIT = 300;
    private final AtomicInteger counter = new AtomicInteger(0);

    private static int getLimit() {
        String limitString = System.getenv(JAMAL_STACK_LIMIT);
        if (limitString == null) {
            return 300;
        }
        try {
            return Integer.parseInt(limitString);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException((Throwable)new BadSyntax("The environment variable JAMAL_STACK_LIMIT should be an integer"));
        }
    }

    public void up() throws BadSyntax {
        if (this.counter.addAndGet(1) > LIMIT) {
            throw new BadSyntax("Jamal source seems to have infinite recursion");
        }
    }

    public int get() {
        return this.counter.get();
    }

    public int down() {
        int downValue = this.counter.addAndGet(-1);
        if (downValue < 0) {
            throw new RuntimeException("Jamal has an internal error. Stack limiter went negative.");
        }
        return downValue;
    }
}

