/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.engine;

import javax.script.ScriptEngine;
import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.Identified;
import javax0.jamal.api.JShellEngine;
import javax0.jamal.engine.ArgumentHandler;
import javax0.jamal.engine.Processor;
import javax0.jamal.tools.ScriptingTools;

public class ScriptMacro
implements javax0.jamal.api.ScriptMacro {
    private final String id;
    private final Processor processor;
    private final String content;
    private final String scriptType;
    final ArgumentHandler argumentHandler;
    private final boolean isJShell;

    public ScriptMacro(Processor processor, String id, String scriptType, String content, String ... parameters) throws BadSyntax {
        this.processor = processor;
        this.scriptType = scriptType;
        this.id = id;
        this.content = content;
        this.argumentHandler = new ArgumentHandler((Identified)this, parameters);
        this.isJShell = scriptType.equals("JShell");
    }

    public String getId() {
        return this.id;
    }

    private boolean isLenient() {
        return this.processor.option("lenient").isPresent();
    }

    public String evaluate(String ... parameters) throws BadSyntax {
        String[] adjustedValues = this.argumentHandler.adjustActualValues(parameters, this.isLenient());
        if (this.isJShell) {
            for (int i = 0; i < this.argumentHandler.parameters.length; ++i) {
                ScriptingTools.populateJShell((JShellEngine)this.processor.getJShellEngine(), (String)this.argumentHandler.parameters[i], (String)adjustedValues[i]);
            }
            return this.processor.getJShellEngine().evaluate(this.content);
        }
        ScriptEngine engine = ScriptingTools.getEngine((String)this.scriptType);
        for (int i = 0; i < this.argumentHandler.parameters.length; ++i) {
            ScriptingTools.populate((ScriptEngine)engine, (String)this.argumentHandler.parameters[i], (String)adjustedValues[i]);
        }
        try {
            return ScriptingTools.resultToString((Object)ScriptingTools.evaluate((ScriptEngine)engine, (String)this.content));
        }
        catch (Exception e) {
            throw new BadSyntax("Script '" + this.id + "' threw exception", (Throwable)e);
        }
    }

    public int expectedNumberOfArguments() {
        return this.argumentHandler.parameters.length;
    }
}

