/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.engine;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.BadSyntaxAt;
import javax0.jamal.api.Closer;
import javax0.jamal.api.Context;
import javax0.jamal.api.Debugger;
import javax0.jamal.api.Evaluable;
import javax0.jamal.api.Macro;
import javax0.jamal.api.Position;
import javax0.jamal.engine.JShellEngine;
import javax0.jamal.engine.NullDebugger;
import javax0.jamal.engine.ScriptMacro;
import javax0.jamal.engine.StackLimiter;
import javax0.jamal.engine.UserDefinedMacro;
import javax0.jamal.engine.debugger.DebuggerFactory;
import javax0.jamal.engine.macro.MacroRegister;
import javax0.jamal.engine.util.ExceptionDumper;
import javax0.jamal.engine.util.MacroBodyFetcher;
import javax0.jamal.engine.util.MacroQualifier;
import javax0.jamal.engine.util.PrefixComposer;
import javax0.jamal.tools.Input;
import javax0.jamal.tools.InputHandler;
import javax0.jamal.tools.Marker;
import javax0.jamal.tools.OptionsStore;
import javax0.jamal.tracer.TraceRecord;
import javax0.jamal.tracer.TraceRecordFactory;

public class Processor
implements javax0.jamal.api.Processor {
    private static final String[] ZERO_STRING_ARRAY = new String[0];
    private final javax0.jamal.api.MacroRegister macros = new MacroRegister();
    private final TraceRecordFactory traceRecordFactory = new TraceRecordFactory();
    private final StackLimiter limiter = new StackLimiter();
    private final JShellEngine shellEngine = new JShellEngine();
    private final Set<AutoCloseable> openResources = new LinkedHashSet<AutoCloseable>();
    private final Context context;
    private final Debugger debugger;
    final Deque<BadSyntax> exceptions = new ArrayDeque<BadSyntax>();
    private static final Optional<Boolean> OPTIONAL_TRUE = Optional.of(true);

    public Processor(String macroOpen, String macroClose, Context context) {
        this.context = context;
        try {
            this.macros.separators(macroOpen, macroClose);
        }
        catch (BadSyntax badSyntax) {
            throw new IllegalArgumentException("neither the macroOpen nor the macroClose arguments to the constructor Processor() can be null");
        }
        Macro.getInstances().forEach(arg_0 -> ((javax0.jamal.api.MacroRegister)this.macros).define(arg_0));
        this.debugger = DebuggerFactory.build(this);
    }

    public Processor(String macroOpen, String macroClose) {
        this(macroOpen, macroClose, null);
    }

    public Processor() {
        this("{", "}");
    }

    public javax0.jamal.api.UserDefinedMacro newUserDefinedMacro(String id, String input, String ... params) throws BadSyntax {
        return this.newUserDefinedMacro(id, input, false, params);
    }

    public javax0.jamal.api.UserDefinedMacro newUserDefinedMacro(String id, String input, boolean verbatim, String ... params) throws BadSyntax {
        return new UserDefinedMacro(this, id, input, verbatim, params);
    }

    public ScriptMacro newScriptMacro(String id, String scriptType, String input, String ... params) throws BadSyntax {
        return new ScriptMacro(this, id, scriptType, input, params);
    }

    public String process(javax0.jamal.api.Input input) throws BadSyntax {
        this.limiter.up();
        javax0.jamal.api.Marker marker = this.macros.test();
        Input output = Input.makeInput();
        try {
            while (input.length() > 0) {
                this.debugger.setBefore(this.limiter.get(), (CharSequence)input);
                if (input.indexOf(this.macros.open()) == 0) {
                    InputHandler.skip((javax0.jamal.api.Input)input, (String)this.macros.open());
                    InputHandler.skipWhiteSpaces((javax0.jamal.api.Input)input);
                    this.processMacro(input, (javax0.jamal.api.Input)output);
                } else {
                    this.processText(input, (javax0.jamal.api.Input)output);
                }
                this.debugger.setAfter(this.limiter.get(), (CharSequence)output);
            }
        }
        catch (BadSyntaxAt bsAt) {
            this.traceRecordFactory.dump((Exception)((Object)bsAt));
            if (!(this.debugger instanceof NullDebugger)) {
                this.debugger.setAfter(this.limiter.get(), (CharSequence)ExceptionDumper.dump(bsAt));
            }
            throw bsAt;
        }
        finally {
            if (this.limiter.down() == 0) {
                this.closeProcess((javax0.jamal.api.Input)output);
            }
        }
        this.traceRecordFactory.dump(null);
        this.macros.test(marker);
        return output.toString();
    }

    public javax0.jamal.api.MacroRegister getRegister() {
        return this.macros;
    }

    public JShellEngine getJShellEngine() {
        return this.shellEngine;
    }

    private void processText(javax0.jamal.api.Input input, javax0.jamal.api.Input output) {
        try (TraceRecord tr = this.traceRecordFactory.openTextRecord(input.getPosition());){
            int nextMacroStart = input.indexOf(this.macros.open());
            if (nextMacroStart != -1) {
                String text = input.substring(0, nextMacroStart);
                this.debugger.setStart((CharSequence)text);
                tr.appendResultState(text);
                output.append((Object)text);
                InputHandler.skip((javax0.jamal.api.Input)input, (int)nextMacroStart);
            } else {
                this.debugger.setStart((CharSequence)input);
                output.append((Object)input);
                input.reset();
            }
        }
    }

    private void processMacro(javax0.jamal.api.Input input, javax0.jamal.api.Input output) throws BadSyntax {
        try (TraceRecord tr = this.traceRecordFactory.openMacroRecord(input.getPosition());){
            String text;
            MacroQualifier qualifiers;
            Position pos = input.getPosition();
            PrefixComposer.Prefix prefix = PrefixComposer.compose(input);
            if (prefix.identCount > 0) {
                this.outputUnevaluated(input, output, prefix);
                return;
            }
            Position position = input.getPosition();
            String macroRaw = this.getNextMacroBody(input);
            Marker marker = new Marker(macroRaw, position);
            this.macros.push((javax0.jamal.api.Marker)marker);
            String macroProcessed = this.getMacroPreProcessed(macroRaw, pos, tr);
            try {
                qualifiers = new MacroQualifier(this, (javax0.jamal.api.Input)Input.makeInput((String)macroProcessed, (Position)pos), prefix.postEvalCount);
            }
            catch (BadSyntax bs) {
                this.pushBadSyntax(bs, pos);
                if (tr != null) {
                    tr.close();
                }
                return;
            }
            if (qualifiers.isInnerScopeDependent()) {
                text = this.evalMacro(tr, qualifiers, () -> this.macros.pop((javax0.jamal.api.Marker)marker), this::noop);
            } else if (qualifiers.isBuiltIn) {
                BadSyntaxAt.run(() -> this.macros.pop((javax0.jamal.api.Marker)marker)).orThrowWith(qualifiers.input.getPosition());
                text = this.evalMacro(tr, qualifiers, this::noop, this::noop);
            } else {
                text = this.evalMacro(tr, qualifiers, () -> this.macros.pop((javax0.jamal.api.Marker)marker), () -> this.macros.lock((javax0.jamal.api.Marker)marker));
            }
            tr.appendResultState(text);
            output.append((Object)text);
        }
    }

    private String getMacroPreProcessed(String macroRaw, Position pos, TraceRecord tr) throws BadSyntax {
        tr.appendBeforeState(macroRaw);
        if (InputHandler.firstCharIs((CharSequence)macroRaw, (char[])new char[]{'@'})) {
            return macroRaw;
        }
        Input macroInputBefore = Input.makeInput((String)macroRaw, (Position)pos);
        if (InputHandler.firstCharIs((CharSequence)macroRaw, (char[])new char[]{'#'})) {
            String macroProcessed = this.process((javax0.jamal.api.Input)macroInputBefore);
            tr.appendAfterEvaluation(macroProcessed);
            return macroProcessed;
        }
        String macroProcessed = this.processUdMacroOldStyleOrNone(macroRaw, (javax0.jamal.api.Input)macroInputBefore);
        tr.appendAfterEvaluation(macroProcessed);
        return macroProcessed;
    }

    private void outputUnevaluated(javax0.jamal.api.Input input, javax0.jamal.api.Input output, PrefixComposer.Prefix prefix) throws BadSyntaxAt {
        output.append((Object)(this.getRegister().open() + prefix.string + this.getNextMacroBody(input) + this.getRegister().close()));
    }

    private void noop() {
    }

    private String processUdMacroOldStyleOrNone(String macroRaw, javax0.jamal.api.Input macroInputBefore) throws BadSyntax {
        if (this.option("omasalgotm").isPresent()) {
            return this.process(macroInputBefore);
        }
        return macroRaw;
    }

    private String evalMacro(TraceRecord tr, MacroQualifier qualifier, Runnable popper, Runnable locker) throws BadSyntax {
        Position ref = qualifier.input.getPosition();
        tr.setId(qualifier.macroId);
        if (qualifier.isBuiltIn) {
            return this.evaluateBuiltInMacro(tr, qualifier, popper);
        }
        tr.type(TraceRecord.Type.USER_DEFINED_MACRO);
        try {
            String rawResult = this.evalUserDefinedMacro(qualifier.input, tr, qualifier);
            locker.run();
            if (qualifier.isVerbatim) {
                if (qualifier.postEvalCount > 0) {
                    throw new BadSyntax("Verbatim and ! cannot be used together on a user defined macro.");
                }
                tr.appendAfterEvaluation(rawResult);
                popper.run();
                return rawResult;
            }
            if (qualifier.udMacro != null && qualifier.udMacro.isVerbatim()) {
                if (qualifier.postEvalCount > 0) {
                    --qualifier.postEvalCount;
                    String result = this.evaluateUserDefinedMacro(rawResult, qualifier, popper, tr);
                    ++qualifier.postEvalCount;
                    return result;
                }
                tr.appendAfterEvaluation(rawResult);
                popper.run();
                return rawResult;
            }
            return this.evaluateUserDefinedMacro(rawResult, qualifier, popper, tr);
        }
        catch (BadSyntaxAt bsAt) {
            throw bsAt;
        }
        catch (BadSyntax bs) {
            throw new BadSyntaxAt(bs, ref);
        }
    }

    private String evaluateUserDefinedMacro(String rawResult, MacroQualifier qualifier, Runnable popper, TraceRecord tr) throws BadSyntax {
        String result = this.safeEvaluate(() -> this.process((javax0.jamal.api.Input)Input.makeInput((String)rawResult, (Position)qualifier.input.getPosition())), popper);
        String postEvaluated = this.postEvaluate(result, qualifier.postEvalCount, qualifier.input.getPosition());
        tr.appendAfterEvaluation(postEvaluated);
        return postEvaluated;
    }

    private String evaluateBuiltInMacro(TraceRecord tr, MacroQualifier qualifier, Runnable popper) throws BadSyntax {
        Position ref = qualifier.input.getPosition();
        tr.type(TraceRecord.Type.MACRO);
        String result = this.safeEvaluate(() -> this.evaluateBuiltinMacro(qualifier.input, ref, qualifier.macro), popper);
        String postEvaluated = this.postEvaluate(result, qualifier.postEvalCount, ref);
        tr.appendAfterEvaluation(postEvaluated);
        return postEvaluated;
    }

    private String safeEvaluate(ThrowingStringSupplier supplier, Runnable finalizer) throws BadSyntax {
        Exception savedEx = null;
        try {
            String string = supplier.get();
            return string;
        }
        catch (Exception e) {
            savedEx = e;
            throw e;
        }
        finally {
            try {
                finalizer.run();
            }
            catch (BadSyntax unbalancedMarkers) {
                if (savedEx != null) {
                    savedEx.addSuppressed(unbalancedMarkers);
                    if (savedEx instanceof BadSyntax) {
                        throw (BadSyntax)((Object)savedEx);
                    }
                    throw new BadSyntax("There was an exception", (Throwable)savedEx);
                }
                throw unbalancedMarkers;
            }
        }
    }

    private String postEvaluate(String input, int count, Position ref) throws BadSyntax {
        for (int i = 0; i < count; ++i) {
            input = this.process((javax0.jamal.api.Input)Input.makeInput((String)input, (Position)ref));
        }
        return input;
    }

    private void pushBadSyntax(BadSyntax bs, Position ref) throws BadSyntaxAt {
        BadSyntaxAt bsa;
        BadSyntaxAt badSyntaxAt = bsa = bs instanceof BadSyntaxAt ? (BadSyntaxAt)((Object)bs) : new BadSyntaxAt(bs, ref);
        if (this.option("failfast").isPresent()) {
            throw bsa;
        }
        this.exceptions.push((BadSyntax)((Object)bsa));
    }

    private String evaluateBuiltinMacro(javax0.jamal.api.Input input, Position ref, Macro macro) throws BadSyntaxAt {
        try {
            return macro.evaluate(input, (javax0.jamal.api.Processor)this);
        }
        catch (BadSyntax bs) {
            this.pushBadSyntax(bs, ref);
            return "";
        }
    }

    private String evalUserDefinedMacro(javax0.jamal.api.Input input, TraceRecord tr, MacroQualifier qualifier) throws BadSyntax {
        String id;
        Position ref = input.getPosition();
        InputHandler.skipWhiteSpaces((javax0.jamal.api.Input)input);
        boolean reportUndefBeforeEval = this.doesStartWithQuestionMark(input);
        javax0.jamal.api.Input evaluatedInput = this.evaluateMacroStart(input, qualifier);
        boolean reportUndefAfterEval = this.doesStartWithQuestionMark(evaluatedInput);
        boolean reportUndef = reportUndefBeforeEval && reportUndefAfterEval;
        InputHandler.skipWhiteSpaces((javax0.jamal.api.Input)evaluatedInput);
        qualifier.macroId = id = InputHandler.fetchId((javax0.jamal.api.Input)evaluatedInput);
        if (id.length() == 0) {
            throw new BadSyntaxAt("Zero length user defined macro name was found.", ref);
        }
        InputHandler.skipWhiteSpaces((javax0.jamal.api.Input)evaluatedInput);
        Optional<Evaluable> udMacroOpt = this.macros.getUserDefined(id, "default").filter(ud -> ud instanceof Evaluable).map(ud -> (Evaluable)ud);
        if (reportUndef && udMacroOpt.isEmpty()) {
            this.throwForUndefinedUdMacro(ref, id);
        }
        if (udMacroOpt.isPresent()) {
            qualifier.udMacro = udMacroOpt.get();
            String[] parameters = this.getParameters(tr, qualifier, ref, evaluatedInput, qualifier.udMacro, id);
            tr.setId(id);
            tr.setParameters(parameters);
            try {
                qualifier.udMacro.setCurrentId(id);
                return qualifier.udMacro.evaluate(parameters);
            }
            catch (BadSyntax bs) {
                this.pushBadSyntax(bs, ref);
                return "";
            }
        }
        return "";
    }

    private void throwForUndefinedUdMacro(Position ref, String id) throws BadSyntaxAt {
        Optional optMacro = this.macros.getMacro(id);
        if (optMacro.isPresent()) {
            this.pushBadSyntax(new BadSyntax("User defined macro '" + this.getRegister().open() + id + "' is not defined. Did you want to use built-in '" + this.getRegister().open() + "@" + id + "' instead?"), ref);
        } else {
            this.pushBadSyntax(new BadSyntax("User defined macro '" + this.getRegister().open() + id + " ...' is not defined."), ref);
        }
    }

    private String[] getParameters(TraceRecord tr, MacroQualifier qualifier, Position ref, javax0.jamal.api.Input input, Evaluable macro, String id) throws BadSyntax {
        String[] parameters;
        if (input.length() > 0) {
            char separator = input.charAt(0);
            if (!(qualifier.oldStyle || macro.expectedNumberOfArguments() != 0 && macro.expectedNumberOfArguments() != 1)) {
                if (!Character.isLetterOrDigit(separator) && input.indexOf(this.macros.open()) != 0) {
                    InputHandler.skip((javax0.jamal.api.Input)input, (int)1);
                }
                parameters = new String[]{this.process(input)};
            } else {
                InputHandler.skip((javax0.jamal.api.Input)input, (int)1);
                if (Character.isLetterOrDigit(separator)) {
                    if (qualifier.oldStyle) {
                        tr.warning("separator character '" + separator + "' is probably a mistake at " + input.getPosition().file + ":" + input.getPosition().line + ":" + input.getPosition().column);
                    } else {
                        throw new BadSyntaxAt("Invalid separator character '" + separator + "' ", input.getPosition());
                    }
                }
                if (qualifier.oldStyle) {
                    parameters = input.toString().split(Pattern.quote("" + separator), -1);
                } else {
                    parameters = this.splitParameterString(input, separator);
                    for (int i = 0; i < parameters.length; ++i) {
                        parameters[i] = this.process((javax0.jamal.api.Input)Input.makeInput((String)parameters[i], (Position)ref));
                    }
                }
            }
        } else {
            parameters = ZERO_STRING_ARRAY;
        }
        return this.addMacroNameForDefault(parameters, macro, id);
    }

    private String[] addMacroNameForDefault(String[] parameters, Evaluable macro, String id) {
        String[] arguments;
        if (macro.getId().equals("default") && macro instanceof UserDefinedMacro && (arguments = ((UserDefinedMacro)macro).getParameters()).length > 0 && ("$macro".equals(arguments[0]) || "$_".equals(arguments[0]))) {
            String[] modified = new String[parameters.length + 1];
            System.arraycopy(parameters, 0, modified, 1, parameters.length);
            modified[0] = id;
            return modified;
        }
        return parameters;
    }

    private boolean doesStartWithQuestionMark(javax0.jamal.api.Input input) {
        boolean reportUndefBeforeEval;
        boolean bl = reportUndefBeforeEval = !InputHandler.firstCharIs((CharSequence)input, (char[])new char[]{'?'});
        if (!reportUndefBeforeEval) {
            InputHandler.skip((javax0.jamal.api.Input)input, (int)1);
            InputHandler.skipWhiteSpaces((javax0.jamal.api.Input)input);
        }
        return reportUndefBeforeEval;
    }

    private javax0.jamal.api.Input evaluateMacroStart(javax0.jamal.api.Input input, MacroQualifier qualifier) throws BadSyntax {
        Input output = Input.makeInput((String)"", (Position)input.getPosition());
        if (input.indexOf(this.macros.open()) == 0 && !qualifier.oldStyle) {
            while (input.length() > 0 && input.indexOf(this.macros.open()) == 0) {
                InputHandler.skip((javax0.jamal.api.Input)input, (String)this.macros.open());
                String macroStart = this.getNextMacroBody(input);
                javax0.jamal.api.Input macroStartInput = Input.makeInput((String)macroStart, (Position)input.getPosition()).append((Object)this.macros.close());
                Input macroStartOutput = Input.makeInput();
                this.processMacro(macroStartInput, (javax0.jamal.api.Input)macroStartOutput);
                output.append((Object)macroStartOutput);
            }
            InputHandler.skipWhiteSpaces((javax0.jamal.api.Input)output);
            this.checkEvalResultUDMacroName((javax0.jamal.api.Input)output, input.getPosition());
            return output.append((Object)input);
        }
        return input;
    }

    private void checkEvalResultUDMacroName(javax0.jamal.api.Input output, Position pos) throws BadSyntaxAt {
        int i;
        int n = i = InputHandler.firstCharIs((CharSequence)output, (char[])new char[]{'?'}) ? 1 : 0;
        while (i < output.length() && Character.isWhitespace(output.charAt(i))) {
            ++i;
        }
        while (i < output.length() && Macro.validIdChar((char)output.charAt(i))) {
            ++i;
        }
        if (i < output.length() && !Character.isWhitespace(output.charAt(i))) {
            throw new BadSyntaxAt("Macro evaluated result user defined macro name contains the separator. Must not.", pos);
        }
    }

    private String[] splitParameterString(javax0.jamal.api.Input in, char separator) throws BadSyntaxAt {
        String open = this.macros.open();
        String close = this.macros.close();
        ArrayList<String> parameters = new ArrayList<String>();
        String input = in.toString();
        Position pos = in.getPosition();
        int start = 0;
        int searchFrom = 0;
        while (true) {
            int separatorIndex;
            if ((separatorIndex = input.indexOf(separator, searchFrom)) == -1) break;
            int openIndex = input.indexOf(open, searchFrom);
            int closeIndex = input.indexOf(close, searchFrom);
            if (closeIndex < openIndex) {
                throw new BadSyntaxAt("Invalid macro nesting in the last argument of the user defined macro.", pos);
            }
            if (openIndex == -1 || separatorIndex < openIndex) {
                this.appendTheNextParameter(parameters, input, start, separatorIndex);
                searchFrom = start = separatorIndex + 1;
                continue;
            }
            searchFrom = this.stepOverNestedMacros(input, openIndex, pos);
        }
        this.checkForImbalance(input, searchFrom, pos);
        this.appendTheLastParameter(parameters, input, start);
        return parameters.toArray(ZERO_STRING_ARRAY);
    }

    private void checkForImbalance(String input, int searchFrom, Position pos) throws BadSyntaxAt {
        String close = this.macros.close();
        String open = this.macros.open();
        int openIndex = input.indexOf(open, searchFrom);
        int closeIndex = input.indexOf(close, searchFrom);
        if (openIndex != -1) {
            if (closeIndex < openIndex) {
                throw new BadSyntaxAt("Invalid macro nesting in the last argument of the user defined macro.", pos);
            }
            while ((openIndex = this.stepOverNestedMacros(input, openIndex, pos)) >= input.length()) {
                closeIndex = input.indexOf(close, openIndex);
                if ((openIndex = input.indexOf(open, openIndex)) != -1) continue;
                if (closeIndex != -1) {
                    throw new BadSyntaxAt("There are trailing macro closing strings in the last argument of the user defined macro.", pos);
                }
                break;
            }
        } else if (input.indexOf(closeIndex, searchFrom) != -1) {
            throw new BadSyntaxAt("Invalid macro nesting in the last argument of the user defined macro.", pos);
        }
    }

    private void appendTheNextParameter(List<String> parameters, String input, int start, int separatorIndex) {
        parameters.add(input.substring(start, separatorIndex));
    }

    private void appendTheLastParameter(List<String> parameters, String input, int start) {
        if (start < input.length()) {
            parameters.add(input.substring(start));
        } else {
            parameters.add("");
        }
    }

    private int stepOverNestedMacros(String input, int start, Position pos) throws BadSyntaxAt {
        String open = this.macros.open();
        String close = this.macros.close();
        int searchFrom = start + open.length();
        int depth = 1;
        while (true) {
            int openIndex = input.indexOf(open, searchFrom);
            int closeIndex = input.indexOf(close, searchFrom);
            if (openIndex == -1 && closeIndex == -1) {
                throw new BadSyntaxAt("Invalid macro nesting in the argument of the user defined macro." + input, pos);
            }
            if (openIndex == -1 || closeIndex < openIndex) {
                searchFrom = closeIndex + close.length();
                if (--depth != 0) continue;
                break;
            }
            searchFrom = openIndex + open.length();
            ++depth;
        }
        return searchFrom;
    }

    String getNextMacroBody(javax0.jamal.api.Input input) throws BadSyntaxAt {
        String body = MacroBodyFetcher.getNextMacroBody(input, this);
        this.debugger.setStart((CharSequence)(this.getRegister().open() + body + this.getRegister().close()));
        return body;
    }

    public void close() {
        this.shellEngine.close();
        this.debugger.close();
    }

    public Deque<BadSyntax> errors() {
        return this.exceptions;
    }

    public void throwUp() throws BadSyntax {
        throw this.exceptions.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeProcess(javax0.jamal.api.Input result) throws BadSyntax {
        ArrayDeque<BadSyntax> exceptions = new ArrayDeque<BadSyntax>(this.exceptions);
        try {
            for (AutoCloseable resource : this.openResources) {
                try {
                    this.setAwares(resource, result);
                    resource.close();
                }
                catch (Exception e) {
                    exceptions.push((BadSyntax)((Object)e));
                }
            }
        }
        finally {
            this.openResources.clear();
        }
        if (!exceptions.isEmpty()) {
            int nrofExceptions = exceptions.size();
            if (nrofExceptions == 1 && exceptions.peek() instanceof BadSyntax) {
                throw (BadSyntax)((Object)exceptions.peek());
            }
            StringBuilder sb = new StringBuilder("There " + (nrofExceptions == 1 ? "was" : "were") + " " + nrofExceptions + " syntax error" + (nrofExceptions == 1 ? "" : "s") + " processing the Jamal input:\n");
            int ser = nrofExceptions;
            for (Throwable throwable : exceptions) {
                sb.append(ser--).append(". ").append(throwable.getMessage()).append("\n");
            }
            BadSyntax exception = new BadSyntax(sb.toString());
            for (Throwable throwable : exceptions) {
                exception.addSuppressed(throwable);
            }
            throw exception;
        }
    }

    private void setAwares(AutoCloseable resource, javax0.jamal.api.Input result) {
        if (resource instanceof Closer.ProcessorAware) {
            ((Closer.ProcessorAware)resource).set((javax0.jamal.api.Processor)this);
        }
        if (resource instanceof Closer.OutputAware) {
            ((Closer.OutputAware)resource).set(result);
        }
    }

    public Context getContext() {
        return this.context;
    }

    public void deferredClose(AutoCloseable resource) {
        this.openResources.add(resource);
    }

    Optional<Boolean> option(String optionName) {
        return OptionsStore.getInstance((javax0.jamal.api.Processor)this).is(optionName) ? OPTIONAL_TRUE : Optional.empty();
    }

    private static interface Runnable {
        public void run() throws BadSyntax;
    }

    private static interface ThrowingStringSupplier {
        public String get() throws BadSyntax;
    }
}

