/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.engine;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import javax0.jamal.api.BadSyntax;
import javax0.jamal.tools.ScriptingTools;
import jdk.jshell.JShell;
import jdk.jshell.Snippet;
import jdk.jshell.SnippetEvent;
import jdk.jshell.SourceCodeAnalysis;

public class JShellEngine
implements javax0.jamal.api.JShellEngine {
    private JShell js = null;
    private ByteArrayOutputStream output = null;
    private final List<String> deferredDefines = new ArrayList<String>();
    private final AtomicBoolean isOpen = new AtomicBoolean(false);

    private void init() throws BadSyntax {
        this.output = new ByteArrayOutputStream();
        this.js = JShell.builder().out(new PrintStream(this.output)).build();
        this.isOpen.set(true);
        this.js.onShutdown(jShell -> this.isOpen.set(false));
        for (String deferredDefine : this.deferredDefines) {
            this.define(deferredDefine);
        }
    }

    public String evaluate(String input) throws BadSyntax {
        if (this.js == null) {
            this.init();
        }
        this.evaluate(input, Predicate.isEqual((Object)Snippet.Status.RECOVERABLE_NOT_DEFINED).or(Predicate.isEqual((Object)Snippet.Status.REJECTED)));
        return this.output.toString(StandardCharsets.UTF_8);
    }

    public void define(String input) throws BadSyntax {
        if (this.js == null) {
            this.deferredDefines.add(input);
        } else {
            this.evaluate(input, Predicate.isEqual((Object)Snippet.Status.REJECTED));
        }
    }

    private void evaluate(String input, Predicate<Snippet.Status> isError) throws BadSyntax {
        this.output.reset();
        String lastValue = "";
        SourceCodeAnalysis analyzer = this.js.sourceCodeAnalysis();
        String script = input;
        while (script.length() > 0) {
            SourceCodeAnalysis.CompletionInfo info = analyzer.analyzeCompletion(script);
            script = info.remaining();
            SourceCodeAnalysis.Completeness result = info.completeness();
            String source = info.source() + (result == SourceCodeAnalysis.Completeness.COMPLETE_WITH_SEMI ? ";" : "");
            List<SnippetEvent> events = this.evaluateAndGetEvents(source);
            for (SnippetEvent e : events) {
                String string = lastValue = e.value() != null ? e.value() : lastValue;
                if (!isError.test(e.status()) && e.exception() == null) continue;
                throw new BadSyntax("Error in the JShell snippet :\n" + e.snippet() + "\n", (Throwable)e.exception());
            }
        }
        if (this.output.toString(StandardCharsets.UTF_8).length() == 0) {
            if (lastValue.length() > 0 && lastValue.charAt(0) == '\"') {
                lastValue = ScriptingTools.unescape((String)lastValue);
            }
            this.output.writeBytes(lastValue.getBytes(StandardCharsets.UTF_8));
        }
    }

    private List<SnippetEvent> evaluateAndGetEvents(String source) throws BadSyntax {
        List<SnippetEvent> events;
        if (!this.isOpen.get()) {
            throw new BadSyntax("The JShell interpreter was closed. Will not be recreated.");
        }
        PrintStream original = System.err;
        try {
            System.setErr(new PrintStream(OutputStream.nullOutputStream()));
            events = this.js.eval(source);
        }
        catch (Exception e) {
            throw new BadSyntax("The JShell snippet '" + source + "' produced error.", (Throwable)e);
        }
        finally {
            System.setErr(original);
        }
        if (!this.isOpen.get()) {
            throw new BadSyntax("The JShell snippet '" + source + "' closed the JShell interpreter. Will not be recreated.");
        }
        return events;
    }

    public void close() {
        if (this.js != null) {
            this.js.close();
        }
    }
}

