/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.engine;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.Identified;

class ArgumentHandler {
    final String[] parameters;
    private final Identified owner;
    private final int max;
    private final int min;
    private static final String ELIPSIS = "...";

    public ArgumentHandler(Identified owner, String[] parameters) throws BadSyntax {
        this.owner = owner;
        if (parameters.length == 1 && parameters[0].equals(ELIPSIS)) {
            this.min = 0;
            this.max = Integer.MAX_VALUE;
            this.parameters = new String[0];
            return;
        }
        int min = -1;
        int max = -1;
        if (parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i].startsWith(ELIPSIS)) {
                    if (min == -1) {
                        min = i;
                        parameters[i] = parameters[i].substring(ELIPSIS.length()).trim();
                    } else {
                        throw new BadSyntax("There can only be one '...xxx' argument in a define.");
                    }
                }
                if (!parameters[i].endsWith(ELIPSIS)) continue;
                if (parameters.length == 1) {
                    throw new BadSyntax("One parameter macro cannot have 'xxx...' argument.");
                }
                if (max == -1 && i == parameters.length - 1) {
                    max = Integer.MAX_VALUE;
                    parameters[i] = parameters[i].substring(0, parameters[i].length() - ELIPSIS.length()).trim();
                    continue;
                }
                throw new BadSyntax("There can only be one 'xxx...' argument in a define, and it has to be the last one.");
            }
            this.min = min == -1 ? parameters.length : min;
            this.max = max == -1 ? parameters.length : max;
        } else {
            this.max = 0;
            this.min = 0;
        }
        this.parameters = parameters;
    }

    String[] adjustActualValues(String[] actualValues, boolean lenient) throws BadSyntax {
        if (actualValues.length != this.parameters.length) {
            if (lenient) {
                String[] adjustedValues = this.adjustActualValues(actualValues);
                if (adjustedValues != null) {
                    return adjustedValues;
                }
            } else {
                if (this.isFantomParameter(actualValues)) {
                    return new String[0];
                }
                if (actualValues.length < this.min || actualValues.length > this.max) {
                    BadSyntax badSyntax = this.min == this.max ? new BadSyntax(String.format("Macro '%s' needs %d arguments and got %d", this.owner.getId(), this.parameters.length, actualValues.length)) : new BadSyntax(String.format("Macro '%s' needs (%s ... %s) arguments and got %d", this.owner.getId(), "" + this.min, this.max == Integer.MAX_VALUE ? "inf" : "" + this.max, actualValues.length));
                    for (String actual : actualValues) {
                        badSyntax.parameter(actual);
                    }
                    throw badSyntax;
                }
                String[] adjustedValues = this.adjustActualValues(actualValues);
                if (adjustedValues != null) {
                    return adjustedValues;
                }
            }
        }
        return actualValues;
    }

    private String[] adjustActualValues(String[] actualValues) {
        if (actualValues.length < this.parameters.length) {
            String[] adjustedValues = Arrays.copyOf(actualValues, this.parameters.length);
            for (int i = 0; i < adjustedValues.length; ++i) {
                if (adjustedValues[i] != null) continue;
                adjustedValues[i] = "";
            }
            return adjustedValues;
        }
        return null;
    }

    private boolean isFantomParameter(String[] actualValues) {
        if (this.parameters.length != 0 || actualValues.length != 1) {
            return false;
        }
        for (char ch : actualValues[0].toCharArray()) {
            if (Character.isWhitespace(ch)) continue;
            return false;
        }
        return true;
    }

    Map<String, String> buildValueMap(String[] values) {
        HashMap<String, String> map = new HashMap<String, String>(values.length);
        for (int i = 0; i < this.parameters.length; ++i) {
            map.put(this.parameters[i], values[i]);
        }
        return map;
    }
}

