/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.builtins;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.Input;
import javax0.jamal.api.Macro;
import javax0.jamal.api.MacroRegister;
import javax0.jamal.api.Processor;

public class Use
implements Macro {
    private static final Pattern pattern = Pattern.compile("((?:global\\s+)?)([\\w\\d:.]+)(?:\\s+as\\s+([\\w][\\w\\d:]*))?");

    public String evaluate(Input input, Processor processor) throws BadSyntax {
        String[] macroImports;
        for (String macroImport : macroImports = input.toString().split(",")) {
            Macro macro;
            String stripped = macroImport.trim().replace("\n", " ").replace("\r", " ").replace("\t", " ").replaceAll("\\s+", " ");
            if (stripped.length() <= 0) continue;
            Matcher matcher = pattern.matcher(stripped);
            if (!matcher.matches()) {
                throw new BadSyntax("use macro has bad syntax '" + stripped + "'");
            }
            boolean isGlobal = matcher.group(1).length() > 0;
            String klassName = matcher.group(2);
            String alias = matcher.group(3);
            MacroRegister register = processor.getRegister();
            if (klassName.contains(".")) {
                macro = this.forName(klassName, klassName);
            } else {
                if (klassName.contains(":")) {
                    isGlobal = true;
                }
                macro = (Macro)register.getMacro(klassName).orElseThrow(() -> new BadSyntax("There is no built-in macro with the name '" + klassName + "'"));
                if (alias == null || alias.length() == 0) {
                    throw new BadSyntax(String.format("You cannot define an alias for the macro '%s' without actually providing an alias after the 'as'", klassName));
                }
            }
            if (isGlobal) {
                if (alias != null && alias.length() > 0) {
                    register.global(macro, alias);
                    continue;
                }
                register.global(macro);
                continue;
            }
            if (alias != null && alias.length() > 0) {
                register.define(macro, alias);
                continue;
            }
            register.define(macro);
        }
        return "";
    }

    private Macro forName(String klassName, String originalName) throws BadSyntax {
        Macro macro;
        Class<?> klass;
        try {
            klass = Class.forName(klassName);
        }
        catch (Exception e) {
            if (!klassName.contains(".")) {
                throw new BadSyntax("Class '" + originalName + "' cannot be used as macro", (Throwable)e);
            }
            int lastDot = klassName.lastIndexOf(46);
            return this.forName(klassName.substring(0, lastDot) + "$" + klassName.substring(lastDot + 1), originalName);
        }
        try {
            macro = (Macro)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new BadSyntax("Class '" + klassName + "' cannot be used as macro", (Throwable)e);
        }
        return macro;
    }
}

