/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.builtins;

import java.util.Objects;
import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.Input;
import javax0.jamal.api.Macro;
import javax0.jamal.api.Marker;
import javax0.jamal.api.Processor;
import javax0.jamal.tools.InputHandler;

public class Try
implements Macro {
    public String evaluate(Input in, Processor processor) throws BadSyntax {
        boolean query = InputHandler.firstCharIs((CharSequence)in, (char[])new char[]{'?'});
        boolean report = Try.isReport(in, query);
        InputHandler.skipWhiteSpaces((Input)in);
        Marker markerStart = processor.getRegister().test();
        int err = processor.errors().size();
        try {
            return Try.process(in, processor, query, err);
        }
        catch (BadSyntax bs) {
            return Try.process(processor, query, report, markerStart, err, bs);
        }
    }

    private static String process(Processor processor, boolean query, boolean report, Marker markerStart, int err, BadSyntax bs) throws BadSyntax {
        bs = Try.getFirstError(processor, err, bs);
        Try.cleanUpTheMarkerStack(processor, markerStart);
        if (query) {
            return "false";
        }
        if (report) {
            return bs.getShortMessage();
        }
        return "";
    }

    private static String process(Input in, Processor processor, boolean query, int err) throws BadSyntax {
        String result = processor.process(in);
        BadSyntax bs = Try.getFirstError(processor, err, null);
        if (bs != null) {
            throw bs;
        }
        if (query) {
            return "true";
        }
        return result;
    }

    private static BadSyntax getFirstError(Processor processor, int err, BadSyntax bs) {
        while (err < processor.errors().size()) {
            bs = (BadSyntax)((Object)processor.errors().pop());
        }
        return bs;
    }

    private static boolean isReport(Input in, boolean query) {
        if (query) {
            InputHandler.skip((Input)in, (int)1);
            return false;
        }
        boolean report = InputHandler.firstCharIs((CharSequence)in, (char[])new char[]{'!'});
        if (report) {
            InputHandler.skip((Input)in, (int)1);
        }
        return report;
    }

    private static void cleanUpTheMarkerStack(Processor processor, Marker markerStart) throws BadSyntax {
        Marker markerEnd;
        while ((markerEnd = processor.getRegister().test()) != null && !Objects.equals(markerStart, markerEnd)) {
            processor.getRegister().pop(markerEnd);
        }
    }
}

