/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.builtins;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.Input;
import javax0.jamal.api.Macro;
import javax0.jamal.api.Processor;
import javax0.jamal.tools.InputHandler;

public class Sep
implements Macro {
    private static final Pattern PATTERN = Pattern.compile("(\\S+)\\s+(\\S+)");

    public String evaluate(Input input, Processor processor) throws BadSyntax {
        String closeMacro;
        String openMacro;
        InputHandler.trim((Input)input);
        if (input.length() == 0) {
            this.restoreLastSavedDelimiters(processor);
            return "";
        }
        if (input.length() == 1) {
            throw new BadSyntax("macro 'sep' has too short argument, only a singl character");
        }
        if (input.length() == 2) {
            openMacro = input.substring(0, 1);
            closeMacro = input.substring(1);
        } else if (input.length() == 3) {
            openMacro = input.substring(0, 1);
            String sep = input.substring(1, 2);
            closeMacro = input.substring(2);
            if (sep.equals(openMacro) || sep.equals(closeMacro)) {
                String open = processor.getRegister().open();
                String close = processor.getRegister().close();
                throw new BadSyntax(open + "@sep " + input + close + " is not correct. Use something different to separate the two characters.");
            }
        } else {
            Matcher matcher = PATTERN.matcher((CharSequence)input);
            if (matcher.matches()) {
                openMacro = matcher.group(1);
                if (this.misleadingOpenString(openMacro, closeMacro = matcher.group(2))) {
                    String open = processor.getRegister().open();
                    String close = processor.getRegister().close();
                    throw new BadSyntax(open + "@sep " + input + close + " is ambiguous. Use a definition that does not contain spaces.");
                }
            } else {
                String sep = input.substring(0, 1);
                InputHandler.skip((Input)input, (int)1);
                int sepIndex = input.indexOf(sep);
                if (sepIndex == -1) {
                    throw new BadSyntax("macro 'sep' needs two separators, like {@sep/[[/]]} where '/' is the separator");
                }
                openMacro = input.substring(0, sepIndex).trim();
                closeMacro = input.substring(sepIndex + 1).trim();
                if (closeMacro.contains(sep)) {
                    throw new BadSyntax("macro 'sep' closing string must not contain the separator character");
                }
            }
        }
        if (openMacro.length() == 0 || closeMacro.length() == 0) {
            throw new BadSyntax("using macro 'sep' you cannot define zero length macro open and/or macro close strings");
        }
        if (openMacro.equals(closeMacro)) {
            throw new BadSyntax("using macro 'sep' you cannot use the same string as macro opening and macro closing string");
        }
        processor.separators(openMacro, closeMacro);
        return "";
    }

    private boolean misleadingOpenString(String openMacro, String closingMacro) {
        char sep = openMacro.charAt(0);
        return sep == openMacro.charAt(openMacro.length() - 1) && openMacro.length() > 2 && !openMacro.substring(1, openMacro.length() - 1).contains("" + sep) || sep == closingMacro.charAt(0) && closingMacro.length() > 1 && !closingMacro.substring(1).contains("" + sep);
    }

    private void restoreLastSavedDelimiters(Processor processor) throws BadSyntax {
        processor.separators(null, null);
    }
}

