/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.builtins;

import java.util.Arrays;
import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.BadSyntaxAt;
import javax0.jamal.api.Input;
import javax0.jamal.api.Macro;
import javax0.jamal.api.Processor;
import javax0.jamal.tools.InputHandler;

public class Require
implements Macro {
    public String evaluate(Input in, Processor processor) throws BadSyntax {
        Runtime.Version requiredVersion;
        Prefix comparing;
        InputHandler.skipWhiteSpaces((Input)in);
        int exact = InputHandler.startsWith((CharSequence)in, (String[])Prefix.lexes());
        if (exact != -1) {
            comparing = Prefix.values()[exact];
            InputHandler.skip((Input)in, (int)comparing.len());
        } else {
            comparing = Prefix.GREATER_OR_EQUAL;
        }
        try {
            requiredVersion = Processor.jamalVersion((String)in.toString().trim());
        }
        catch (Exception e) {
            throw new BadSyntaxAt("The string '" + in.toString().trim() + "' cannot be used as a version.", in.getPosition(), (Throwable)e);
        }
        if (requiredVersion.compareTo(Processor.jamalVersion((String)"1.6.3")) <= 0) {
            throw new BadSyntaxAt("Required version is older than 1.6.3, which is invalid.", in.getPosition());
        }
        Runtime.Version currentVersion = Processor.jamalVersion();
        switch (comparing) {
            case LESS: {
                if (currentVersion.compareTo(requiredVersion) < 0) break;
                if (currentVersion.compareTo(requiredVersion) == 0) {
                    throw new BadSyntaxAt("The current version " + currentVersion + " is the same as the required version. It has to be older.", in.getPosition());
                }
                throw new BadSyntaxAt("The current version " + currentVersion + " is newer than the required version. It has to be older.", in.getPosition());
            }
            case LESS_OR_EQUAL: {
                if (currentVersion.compareTo(requiredVersion) <= 0) break;
                throw new BadSyntaxAt("The current version " + currentVersion + " is newer than the required version. It has to be older or the same version.", in.getPosition());
            }
            case EQUAL: {
                if (currentVersion.compareTo(requiredVersion) == 0) break;
                throw new BadSyntaxAt("The current version of Jamal is " + currentVersion + ", which is not the same as the required version " + requiredVersion, in.getPosition());
            }
            case GREATER_OR_EQUAL: {
                if (currentVersion.compareTo(requiredVersion) >= 0) break;
                throw new BadSyntaxAt("The current version " + currentVersion + " is older than the required version. It has to be newer.", in.getPosition());
            }
            case GREATER: {
                if (currentVersion.compareTo(requiredVersion) > 0) break;
                if (currentVersion.compareTo(requiredVersion) == 0) {
                    throw new BadSyntaxAt("The current version " + currentVersion + " is the same as the required version. It has to be newer.", in.getPosition());
                }
                throw new BadSyntaxAt("The current version " + currentVersion + " is older than the required version. It has to be newer.", in.getPosition());
            }
            default: {
                throw new IllegalArgumentException("The comparison in require is illegal.");
            }
        }
        return "";
    }

    private static enum Prefix {
        LESS_OR_EQUAL("<="),
        LESS("<"),
        EQUAL("="),
        GREATER_OR_EQUAL(">="),
        GREATER(">");

        final String lex;

        private Prefix(String lex) {
            this.lex = lex;
        }

        int len() {
            return this.lex.length();
        }

        static String[] lexes() {
            return (String[])Arrays.stream(Prefix.values()).map(p -> p.lex).toArray(String[]::new);
        }
    }
}

