/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.builtins;

import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.Identified;
import javax0.jamal.api.Input;
import javax0.jamal.api.Macro;
import javax0.jamal.api.Position;
import javax0.jamal.api.Processor;
import javax0.jamal.tools.FileTools;
import javax0.jamal.tools.InputHandler;
import javax0.jamal.tools.Marker;
import javax0.jamal.tools.Params;

public class Include
implements Macro {
    private int depth = Include.getDepth();
    private static final String JAMAL_INCLUDE_DEPTH = "JAMAL_INCLUDE_DEPTH";
    private static final int DEFAULT_DEPTH = 100;

    private static int getDepth() {
        String limitString = System.getenv(JAMAL_INCLUDE_DEPTH);
        if (limitString == null) {
            return 100;
        }
        try {
            return Integer.parseInt(limitString);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException((Throwable)new BadSyntax("The environment variable JAMAL_INCLUDE_DEPTH should be an integer"));
        }
    }

    public String evaluate(Input input, Processor processor) throws BadSyntax {
        Position position = input.getPosition();
        Params.Param verbatim = Params.holder((String[])new String[]{"includeVerbatim", "verbatim"}).asBoolean();
        Params.using((Processor)processor).from((Identified)this).between("[]").keys(new Params.Param[]{verbatim}).parse(input);
        InputHandler.skipWhiteSpaces((Input)input);
        String reference = input.getReference();
        String fileName = FileTools.absolute((String)reference, (String)input.toString().trim());
        if (this.depth-- == 0) {
            this.depth = Include.getDepth();
            throw new BadSyntax("Include depth is too deep");
        }
        Marker marker = new Marker("{@include " + fileName + "}", position);
        processor.getRegister().push((javax0.jamal.api.Marker)marker);
        String result = (Boolean)verbatim.get() != false ? FileTools.getInput((String)fileName).toString() : processor.process(FileTools.getInput((String)fileName));
        processor.getRegister().pop((javax0.jamal.api.Marker)marker);
        ++this.depth;
        return result;
    }
}

