/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.builtins;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.Input;
import javax0.jamal.api.Marker;
import javax0.jamal.api.Processor;
import javax0.jamal.api.Stackable;
import javax0.jamal.tools.FileTools;
import javax0.jamal.tools.InputHandler;

public class Import
implements Stackable {
    private final List<Set<String>> importedAlready = new ArrayList<Set<String>>();

    public Import() {
        this.push();
    }

    public String evaluate(Input input, Processor processor) throws BadSyntax {
        InputHandler.skipWhiteSpaces((Input)input);
        String reference = input.getReference();
        String fileName = FileTools.absolute((String)reference, (String)input.toString().trim());
        if (this.wasNotImported(fileName)) {
            this.importedAlready.get(this.importedAlready.size() - 1).add(fileName);
            Input in = FileTools.getInput((String)fileName);
            boolean weArePseudoDefault = processor.getRegister().open().equals("{") && processor.getRegister().close().equals("}");
            boolean useDefaultSeparators = in.length() > 1 && in.charAt(0) == '{' && in.charAt(1) == '@' && !weArePseudoDefault;
            Marker marker = processor.getRegister().test();
            if (useDefaultSeparators) {
                processor.separators("{", "}");
                processor.process(in);
                processor.separators(null, null);
            } else {
                processor.process(in);
            }
            processor.getRegister().test(marker);
        }
        return "";
    }

    private boolean wasNotImported(String fileName) {
        for (int level = this.importedAlready.size() - 1; level > -1; --level) {
            Set<String> importSet = this.importedAlready.get(level);
            if (!importSet.contains(fileName)) continue;
            return false;
        }
        return true;
    }

    public void push() {
        this.importedAlready.add(new HashSet());
    }

    public void pop() {
        this.importedAlready.remove(this.importedAlready.size() - 1);
    }
}

