/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.builtins;

import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.BadSyntaxAt;
import javax0.jamal.api.Input;
import javax0.jamal.api.Macro;
import javax0.jamal.api.Position;
import javax0.jamal.api.Processor;
import javax0.jamal.tools.InputHandler;

public class If
implements Macro {
    public String evaluate(Input input, Processor processor) throws BadSyntax {
        Position pos = input.getPosition();
        String[] parts = InputHandler.getParts((Input)input, (int)3);
        if (parts.length < 1) {
            throw new BadSyntaxAt("Macro 'if' needs 1, 2 or 3 arguments", pos);
        }
        if (this.isTrue(parts[0])) {
            return parts.length > 1 ? parts[1] : "";
        }
        return parts.length > 2 ? parts[2] : "";
    }

    private boolean isTrue(String test) {
        if (test.trim().equalsIgnoreCase("true")) {
            return true;
        }
        if (test.trim().equalsIgnoreCase("false")) {
            return false;
        }
        if (test.trim().matches("[+-]?\\d+")) {
            return Integer.parseInt(test) != 0;
        }
        return test.trim().length() > 0;
    }
}

