/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.builtins;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.BadSyntaxAt;
import javax0.jamal.api.Identified;
import javax0.jamal.api.InnerScopeDependent;
import javax0.jamal.api.Input;
import javax0.jamal.api.Macro;
import javax0.jamal.api.ObjectHolder;
import javax0.jamal.api.Processor;
import javax0.jamal.tools.InputHandler;
import javax0.jamal.tools.Params;

public class For
implements Macro,
InnerScopeDependent {
    Params.Param<String> separator;
    Params.Param<String> subSeparator;
    Params.Param<Boolean> trim;
    Params.Param<Boolean> skipEmpty;
    Params.Param<Boolean> lenient;
    Params.Param<Boolean> evalValueList;
    Processor processor;

    public String evaluate(Input input, Processor processor) throws BadSyntax {
        String[][] valueMatrix;
        For it = new For();
        it.processor = processor;
        it.separator = Params.holder((String[])new String[]{"$forsep", "separator"}).orElse(",");
        it.subSeparator = Params.holder((String[])new String[]{"$forsubsep", "subseparator"}).orElse("\\|");
        it.trim = Params.holder((String[])new String[]{"trimForValues", "trim"}).asBoolean();
        it.skipEmpty = Params.holder((String[])new String[]{"skipForEmpty", "skipEmpty"}).asBoolean();
        it.lenient = Params.holder((String[])new String[]{"lenient"}).asBoolean();
        it.evalValueList = Params.holder((String[])new String[]{"evaluateValueList", "evalist"}).asBoolean();
        Params.using((Processor)processor).from((Identified)this).between("[]").keys(new Params.Param[]{it.subSeparator, it.separator, it.trim, it.skipEmpty, it.lenient, it.evalValueList}).parse(input);
        InputHandler.skipWhiteSpaces((Input)input);
        String[] variables = For.getVariables(input);
        InputHandler.skipWhiteSpaces((Input)input);
        switch (For.checkKeyword(input)) {
            case IN: {
                valueMatrix = it.getValueMatrix(input, variables);
                break;
            }
            case FROM: {
                String source = InputHandler.fetchId((Input)input);
                Object sourceObject = processor.getRegister().getUserDefined(source).filter(m -> m instanceof ObjectHolder).map(m -> (ObjectHolder)m).map(ObjectHolder::getObject).orElseThrow(() -> new BadSyntax(String.format("The user defined macro '%s' does not exist or cannot be used as data source for a 'for' loop.", source)));
                valueMatrix = it.getValueMatrix(sourceObject, variables.length);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown keyword following the 'for'");
            }
        }
        InputHandler.skipWhiteSpaces((Input)input);
        For.checkEqualSign(input);
        String content = input.toString();
        StringBuilder output = new StringBuilder();
        Segment root = For.splitContentToSegments(variables, content);
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        for (String[] values : valueMatrix) {
            if (values == null) continue;
            for (int i = 0; i < variables.length; ++i) {
                parameterMap.put(variables[i], i < values.length ? values[i] : "");
            }
            for (Segment segment = root; segment != null; segment = segment.next()) {
                output.append(segment.content(parameterMap));
            }
        }
        return output.toString();
    }

    private String[][] getValueMatrix(Object object, int nrOfVariables) {
        List<?> valueListList = this.convertObjectToListList(object, nrOfVariables);
        String[][] result = new String[valueListList.size()][];
        for (int i = 0; i < result.length; ++i) {
            List<String> valueList = this.convertObjectToStringList(valueListList.get(i), nrOfVariables);
            while (valueList.size() < nrOfVariables) {
                valueList.add("");
            }
            result[i] = (String[])valueList.toArray(String[]::new);
        }
        return result;
    }

    private List<String> convertObjectToStringList(Object object, int nrOfVariables) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object v : this.convertObjectToListList(object, nrOfVariables)) {
            list.add(v.toString());
        }
        return list;
    }

    private static String nullToEmpty(Object object) {
        if (object == null) {
            return "";
        }
        return "" + object;
    }

    private List<?> convertObjectToListList(Object object, int nrOfVariables) {
        List<Object> valueList = object instanceof Object[] ? List.of((Object[])object) : (object instanceof Set ? new ArrayList<Object>(List.of(((Set)object).toArray())) : (object instanceof List ? new ArrayList<Object>((List)object) : (object instanceof Stream ? ((Stream)object).collect(Collectors.toList()) : (object instanceof Map ? (nrOfVariables > 1 ? this.map2KeyValueLists((Map)object) : new ArrayList<Object>(List.of(((Map)object).keySet().toArray()))) : new ArrayList<CallSite>(List.of("" + object))))));
        return valueList;
    }

    private List<?> map2KeyValueLists(Map<?, ?> map) {
        List valueList = map.entrySet().stream().map(e -> List.of(For.nullToEmpty(e.getKey()), For.nullToEmpty(e.getValue()))).collect(Collectors.toList());
        return valueList;
    }

    private String[][] getValueMatrix(Input input, String[] variables) throws BadSyntax {
        if (InputHandler.firstCharIs((CharSequence)input, (char[])new char[]{'('})) {
            return this.createValueMatrixFromString(For.getValuesStringFromSimpleList(input), variables);
        }
        if (InputHandler.firstCharIs((CharSequence)input, (char[])new char[]{'`'})) {
            return this.createValueMatrixFromString(this.getValuesStringFromStringTerminatedList(input), variables);
        }
        throw new BadSyntaxAt("for macro has bad syntax '" + input + "'", input.getPosition());
    }

    private String[][] createValueMatrixFromString(String valuesString, String[] variables) throws BadSyntax {
        if (this.evalValueList.is()) {
            valuesString = this.processor.process((Input)javax0.jamal.tools.Input.makeInput((String)valuesString));
        }
        String[] valueArray = valuesString.split((String)this.separator.get(), -1);
        String[][] valueMatrix = new String[valueArray.length][];
        for (int j = 0; j < valueArray.length; ++j) {
            String value = valueArray[j];
            if (value.length() <= 0 && this.skipEmpty.is()) continue;
            String[] values = value.split((String)this.subSeparator.get(), -1);
            if (!this.lenient.is() && values.length != variables.length) {
                throw new BadSyntax("number of the values does not match the number of the parameters\n" + String.join((CharSequence)",", variables) + "\n" + value);
            }
            if (this.trim.is()) {
                for (int i = 0; i < values.length; ++i) {
                    values[i] = values[i].trim();
                }
            }
            valueMatrix[j] = values;
        }
        return valueMatrix;
    }

    private static Segment splitContentToSegments(String[] variables, String content) {
        Segment root = new Segment(null, content);
        for (String variable : variables) {
            Segment it = root;
            while (it != null) {
                Segment next = it.nextSeg;
                it.split(variable);
                it = next;
            }
        }
        return root;
    }

    private static void checkEqualSign(Input input) throws BadSyntaxAt {
        if (!InputHandler.firstCharIs((CharSequence)input, (char[])new char[]{'='})) {
            throw new BadSyntaxAt("for macro has bad syntax, missing '=' at '" + input + "'", input.getPosition());
        }
        InputHandler.skip((Input)input, (int)1);
    }

    private String getValuesStringFromStringTerminatedList(Input input) throws BadSyntaxAt {
        InputHandler.skip((Input)input, (int)1);
        int closingTick = input.indexOf("`");
        if (closingTick == -1) {
            throw new BadSyntaxAt("There is no closing '`' before the values in the for macro.", input.getPosition());
        }
        String stopString = "`" + input.substring(0, closingTick + 1);
        InputHandler.skip((Input)input, (int)(closingTick + 1));
        int closing = input.indexOf(stopString);
        if (closing == -1) {
            throw new BadSyntaxAt("There is no closing " + stopString + " for the values in the for macro.", input.getPosition());
        }
        String valuesString = input.substring(0, closing);
        InputHandler.skip((Input)input, (int)(closing + stopString.length()));
        return valuesString;
    }

    private static String getValuesStringFromSimpleList(Input input) throws BadSyntaxAt {
        InputHandler.skip((Input)input, (int)1);
        int closing = input.indexOf(")");
        if (closing == -1) {
            throw new BadSyntaxAt("There is no closing ')' for the values in the for macro.", input.getPosition());
        }
        String valuesString = input.substring(0, closing);
        InputHandler.skip((Input)input, (int)(closing + 1));
        return valuesString;
    }

    private static KeyWord checkKeyword(Input input) throws BadSyntaxAt {
        String keyword = InputHandler.fetchId((Input)input);
        InputHandler.skipWhiteSpaces((Input)input);
        switch (keyword) {
            case "in": {
                return KeyWord.IN;
            }
            case "from": {
                return KeyWord.FROM;
            }
        }
        throw new BadSyntaxAt("The keyword 'in/from' is missing in the 'for' macro '" + input + "'", input.getPosition());
    }

    private static String[] getVariables(Input input) throws BadSyntaxAt {
        String[] variables = InputHandler.firstCharIs((CharSequence)input, (char[])new char[]{'('}) ? InputHandler.getParameters((Input)input, (String)"for loop") : new String[]{InputHandler.fetchId((Input)input)};
        return variables;
    }

    private static enum KeyWord {
        IN,
        FROM;

    }

    private static class Segment {
        Segment nextSeg;
        String text;
        final boolean isText;

        Segment(Segment nextSeg, String text) {
            this(nextSeg, text, true);
        }

        Segment(Segment nextSeg, String text, boolean isText) {
            this.nextSeg = nextSeg;
            this.text = text;
            this.isText = isText;
        }

        private static void split(Segment root, String parameter) {
            Segment it = root;
            while ((it = Segment.splitAndGetNext(it, parameter)) != null) {
            }
        }

        private static Segment splitAndGetNext(Segment it, String parameter) {
            if (!it.isText) {
                return null;
            }
            int start = it.text.indexOf(parameter);
            if (start < 0) {
                return null;
            }
            Segment textSeg = new Segment(it.nextSeg, it.text.substring(start + parameter.length()));
            it.nextSeg = new Segment(textSeg, parameter, false);
            it.text = it.text.substring(0, start);
            return textSeg;
        }

        String content(Map<String, String> params) {
            return this.isText ? this.text : params.get(this.text);
        }

        Segment next() {
            return this.nextSeg;
        }

        void split(String parameter) {
            Segment.split(this, parameter);
        }
    }
}

