/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.builtins;

import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.BadSyntaxAt;
import javax0.jamal.api.Input;
import javax0.jamal.api.Macro;
import javax0.jamal.api.Position;
import javax0.jamal.api.Processor;
import javax0.jamal.tools.InputHandler;

public class Escape
implements Macro {
    public String evaluate(Input in, Processor processor) throws BadSyntax {
        InputHandler.skipWhiteSpaces((Input)in);
        if (in.charAt(0) != '`') {
            throw new BadSyntaxAt("The macro escape needs an escape string enclosed between ` characters.", in.getPosition());
        }
        InputHandler.skip((Input)in, (int)1);
        int endOfEscape = in.indexOf("`");
        if (endOfEscape == -1) {
            throw new BadSyntaxAt("The macro escape needs an escape string enclosed between ` characters. Closing ` is not found.", in.getPosition());
        }
        String escapeSequence = "`" + in.subSequence(0, endOfEscape).toString() + "`";
        InputHandler.skip((Input)in, (int)(escapeSequence.length() - 1));
        int endOfString = in.indexOf(escapeSequence);
        if (endOfString == -1) {
            throw new BadSyntaxAt("I cannot find the escape string at the end of the macro: " + escapeSequence, in.getPosition());
        }
        String escapedString = in.substring(0, endOfString);
        InputHandler.skip((Input)in, (String)escapedString);
        InputHandler.skip((Input)in, (String)escapeSequence);
        InputHandler.skipWhiteSpaces((Input)in);
        if (in.length() > 0) {
            throw new BadSyntaxAt("There are extra characters in the use of {@escape } after the closing escape sequence: " + escapeSequence, in.getPosition());
        }
        return escapedString;
    }

    public String fetch(Processor processor, Input input) throws BadSyntaxAt {
        javax0.jamal.tools.Input output = javax0.jamal.tools.Input.makeInput();
        Position start = input.getPosition();
        InputHandler.moveWhiteSpaces((Input)input, (Input)output);
        InputHandler.move((Input)input, (int)1, (Input)output);
        InputHandler.moveWhiteSpaces((Input)input, (Input)output);
        output.append((Object)InputHandler.fetchId((Input)input));
        InputHandler.moveWhiteSpaces((Input)input, (Input)output);
        if (input.charAt(0) != '`') {
            throw new BadSyntaxAt("The macro escape needs an escape string enclosed between ` characters.", input.getPosition());
        }
        InputHandler.move((Input)input, (int)1, (Input)output);
        int endOfEscape = input.indexOf("`");
        if (endOfEscape == -1) {
            throw new BadSyntaxAt("The macro escape needs an escape string enclosed between ` characters. Closing ` is not found.", input.getPosition());
        }
        String escapeSequence = "`" + input.subSequence(0, endOfEscape).toString() + "`";
        InputHandler.move((Input)input, (int)(escapeSequence.length() - 1), (Input)output);
        int endOfString = input.indexOf(escapeSequence);
        if (endOfString == -1) {
            throw new BadSyntaxAt("I cannot find the escape string at the end of the macro: " + escapeSequence, input.getPosition());
        }
        InputHandler.move((Input)input, (int)endOfString, (Input)output);
        InputHandler.move((Input)input, (int)escapeSequence.length(), (Input)output);
        String closeStr = processor.getRegister().close();
        int endOfEscapeMacro = input.indexOf(closeStr);
        if (endOfEscapeMacro == -1) {
            throw new BadSyntaxAt("Escape macro is not closed", start);
        }
        InputHandler.move((Input)input, (int)endOfEscapeMacro, (Input)output);
        InputHandler.skip((Input)input, (String)closeStr);
        return output.toString();
    }
}

