/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.tools.syntax;

import javax0.geci.tools.syntax.Lexeme;

public class Lexer {
    private static final Lexeme EOF = new Lexeme("", Lexeme.Type.EOF);
    private final StringBuilder input;
    private final boolean selectorExpression;
    private Lexeme lookAhead = null;

    public Lexer(String input) {
        this(input, false);
    }

    public Lexer(String input, boolean selectorExpression) {
        String preprocessed = selectorExpression ? input.trim().replaceAll("\\s+", " ") : input.trim().replaceAll("\\s+", " ").replaceAll("\\s*\\|\\s*", "|").replaceAll("\\s*,\\s*", ",").replaceAll("\\(\\s*", "(").replaceAll("\\s*\\)", ")").replaceAll("\\s*\\?", "?").replaceAll("\\s*\\*", "*").replaceAll("\\s*\\+", "+").replaceAll("\\s*-\\s*>\\s*", "->");
        this.input = new StringBuilder(preprocessed);
        this.selectorExpression = selectorExpression;
    }

    public String toString() {
        return "\"" + this.rest() + "\"";
    }

    public String rest() {
        if (this.lookAhead == null) {
            return this.input.toString();
        }
        return this.lookAhead + this.input.toString();
    }

    public Lexeme get() {
        Lexeme ret = this.lookAhead != null ? this.lookAhead : this.next();
        this.lookAhead = this.next();
        return ret;
    }

    public Lexeme peek() {
        if (this.lookAhead == null) {
            this.lookAhead = this.next();
        }
        return this.lookAhead;
    }

    private Lexeme next() {
        if (this.inputStartsWithSpace()) {
            this.deleteSpaceFromTheStartOfInput();
            if (!this.selectorExpression) {
                return new Lexeme(" ", Lexeme.Type.SPACE);
            }
        }
        if (this.input.length() == 0) {
            return EOF;
        }
        if (this.inputStartsWithAnIdentifier()) {
            StringBuilder word = new StringBuilder();
            boolean inArgs = false;
            while (this.input1stCharIsStillPartOfMethodPrototype(inArgs)) {
                char c = this.input.charAt(0);
                word.append(this.input.charAt(0));
                this.deleteOneCharacter();
                if ('(' == c) {
                    inArgs = true;
                    continue;
                }
                if (')' != c) continue;
                break;
            }
            return new Lexeme(word.toString(), Lexeme.Type.WORD);
        }
        if (this.inputStartsWithRegex()) {
            StringBuilder regex = new StringBuilder();
            this.deleteOneCharacter();
            while (this.regexIsNotFinished()) {
                if (this.inputStartsWithEscapedRegexDelimiter()) {
                    this.deleteOneCharacter();
                }
                regex.append(this.input.charAt(0));
                this.deleteOneCharacter();
            }
            if (this.input.length() > 0) {
                this.deleteOneCharacter();
            }
            return new Lexeme(regex.toString(), Lexeme.Type.REGEX);
        }
        String symbol = this.input.substring(0, 1);
        this.deleteOneCharacter();
        return new Lexeme(symbol, Lexeme.Type.SYMBOL);
    }

    private void deleteOneCharacter() {
        this.input.delete(0, 1);
    }

    private boolean inputStartsWithEscapedRegexDelimiter() {
        return this.input.charAt(0) == '\\' && this.input.length() > 1 && this.input.charAt(1) == '/';
    }

    private boolean regexIsNotFinished() {
        return this.input.length() > 0 && this.input.charAt(0) != '/';
    }

    private boolean inputStartsWithRegex() {
        return this.input.length() > 0 && this.input.charAt(0) == '/';
    }

    private boolean input1stCharIsStillPartOfMethodPrototype(boolean inArgs) {
        return this.input.length() > 0 && (Character.isJavaIdentifierPart(this.input.charAt(0)) || '.' == this.input.charAt(0) || ',' == this.input.charAt(0) && inArgs || '(' == this.input.charAt(0) && !inArgs || ')' == this.input.charAt(0) && inArgs);
    }

    private boolean inputStartsWithAnIdentifier() {
        return Character.isJavaIdentifierStart(this.input.charAt(0));
    }

    private void deleteSpaceFromTheStartOfInput() {
        while (this.inputStartsWithSpace()) {
            this.deleteOneCharacter();
        }
    }

    private boolean inputStartsWithSpace() {
        return this.input.length() > 0 && Character.isWhitespace(this.input.charAt(0));
    }
}

