/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.tools.reflection;

import javax0.geci.tools.reflection.Lexeme;
import javax0.geci.tools.reflection.Lexer;
import javax0.geci.tools.reflection.SelectorNode;

class SelectorCompiler {
    private Lexer lexer;

    SelectorCompiler() {
    }

    static SelectorNode compile(String expression) {
        SelectorCompiler it = new SelectorCompiler();
        it.lexer = new Lexer(expression);
        SelectorNode topNode = it.expression();
        if (it.lexer.rest().length() > 0) {
            throw new IllegalArgumentException("There are extra characters at the end of the selector expression" + it.atRest());
        }
        return topNode;
    }

    private String atRest() {
        Object rest = this.lexer.rest();
        if (((String)rest).length() > 8) {
            rest = ((String)rest).substring(0, 8) + "...";
        }
        return " at '" + (String)rest + "'";
    }

    private boolean isSymbol(String s) {
        return this.lexer.peek().type == Lexeme.Type.SYMBOL && this.lexer.peek().string.equals(s);
    }

    private SelectorNode expression() {
        SelectorNode topNode = this.expression1();
        if (this.isSymbol("|")) {
            SelectorNode.Or orNode = new SelectorNode.Or();
            orNode.subNodes.add(topNode);
            while (this.isSymbol("|")) {
                this.lexer.get();
                orNode.subNodes.add(this.expression1());
            }
            return orNode;
        }
        return topNode;
    }

    private SelectorNode expression1() {
        SelectorNode topNode = this.expression2();
        if (this.isSymbol("&")) {
            SelectorNode.And andNode = new SelectorNode.And();
            andNode.subNodes.add(topNode);
            while (this.isSymbol("&")) {
                this.lexer.get();
                andNode.subNodes.add(this.expression2());
            }
            return andNode;
        }
        return topNode;
    }

    private SelectorNode expression2() {
        if (this.isSymbol("!")) {
            this.lexer.get();
            return new SelectorNode.Not(this.expression2());
        }
        if (this.isSymbol("(")) {
            this.lexer.get();
            SelectorNode sub = this.expression();
            if (this.isSymbol(")")) {
                this.lexer.get();
                return sub;
            }
            throw new IllegalArgumentException("Closing ')' is missing" + this.atRest());
        }
        if (this.lexer.peek().type == Lexeme.Type.WORD) {
            String name = this.lexer.get().string;
            if (this.isSymbol("-")) {
                this.lexer.get();
                if (this.isSymbol(">")) {
                    this.lexer.get();
                    return new SelectorNode.Converted(this.expression2(), name);
                }
                throw new IllegalArgumentException("Conversion is missing -> " + this.atRest());
            }
            if (this.isSymbol("~")) {
                this.lexer.get();
                if (this.lexer.peek().type != Lexeme.Type.REGEX) {
                    throw new IllegalArgumentException("Regex is missing after '~'" + this.atRest());
                }
                Lexeme regex = this.lexer.get();
                return new SelectorNode.Regex(regex.string, name);
            }
            return new SelectorNode.Terminal(name);
        }
        throw new IllegalArgumentException("Invalid syntax" + this.atRest());
    }
}

