/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.tools.reflection;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax0.geci.tools.MethodTool;
import javax0.geci.tools.reflection.SelectorCompiler;
import javax0.geci.tools.reflection.SelectorNode;

public class Selector<T> {
    private static final int SYNTHETIC = 4096;
    private final Map<String, Function<T, Boolean>> selectors = new HashMap<String, Function<T, Boolean>>();
    private final Map<String, Function<T, Object>> converters = new HashMap<String, Function<T, Object>>();
    private final Map<String, BiFunction<T, Pattern, Boolean>> regexMemberSelectors = new HashMap<String, BiFunction<T, Pattern, Boolean>>();
    private SelectorNode top = null;
    private final String expression;

    private Selector(String expression) {
        this.expression = expression;
        this.defineConversions();
        this.methodAndClassOnlySelectors();
        this.universalSelectors();
        this.fieldOnlySelectors();
        this.methodOnlySelectors();
        this.classOnlySelectors();
        this.regexSelector("annotation", (m, regex) -> this.only(m, AnnotatedElement.class) && this.matchAnnotations((AnnotatedElement)m, (Pattern)regex));
        this.selector("annotated", m -> this.only(m, AnnotatedElement.class) && this.hasAnnotations((AnnotatedElement)m));
    }

    private void defineConversions() {
        this.converter("declaringClass", this::getDeclaringClass);
        this.converter("returnType", m -> this.only(m, Method.class) ? ((Method)m).getReturnType() : null);
        this.converter("type", m -> this.only(m, Field.class) ? ((Field)m).getType() : null);
        this.converter("superClass", m -> this.only(m, Class.class) ? ((Class)m).getSuperclass() : null);
        this.converter("enclosingClass", m -> this.only(m, Class.class) ? ((Class)m).getEnclosingClass() : null);
        this.converter("enclosingMethod", m -> this.only(m, Class.class) ? ((Class)m).getEnclosingMethod() : null);
        this.converter("componentType", m -> this.only(m, Class.class) ? ((Class)m).getComponentType() : null);
        this.converter("nestHost", m -> this.only(m, Class.class) ? ((Class)m).getNestHost() : null);
    }

    public static Selector compile(String expression) {
        Selector it = new Selector(expression);
        it.top = SelectorCompiler.compile(expression);
        return it;
    }

    private Class<?> getDeclaringClass(T m) {
        if (m instanceof Class) {
            return ((Class)m).getDeclaringClass();
        }
        if (m instanceof Method) {
            return ((Method)m).getDeclaringClass();
        }
        if (m instanceof Field) {
            return ((Field)m).getDeclaringClass();
        }
        if (m == null) {
            return null;
        }
        throw this.illegalArgumentException("Selector cannot be applied to " + m.getClass());
    }

    private Class<?> toClass(T m) {
        if (m instanceof Class) {
            return (Class)m;
        }
        if (m instanceof Method) {
            return ((Method)m).getReturnType();
        }
        if (m instanceof Field) {
            return ((Field)m).getType();
        }
        throw this.illegalArgumentException("Selector cannot be applied to " + (Serializable)(m == null ? "null " : m.getClass()));
    }

    private void methodAndClassOnlySelectors() {
        this.selector("abstract", m -> this.only(m, Class.class, Method.class) && Modifier.isAbstract(this.getModifiers(m)));
        this.selector("implements", m -> this.only(m, Class.class, Method.class) && this.methodOrClassImplements(m));
    }

    private boolean notNull(T m) {
        return m != null;
    }

    private void classOnlySelectors() {
        this.selector("interface", m -> this.notNull(m) && this.toClass(m).isInterface());
        this.selector("primitive", m -> this.notNull(m) && this.toClass(m).isPrimitive());
        this.selector("annotation", m -> this.notNull(m) && this.toClass(m).isAnnotation());
        this.selector("anonymous", m -> this.notNull(m) && this.toClass(m).isAnonymousClass());
        this.selector("array", m -> this.notNull(m) && this.toClass(m).isArray());
        this.selector("enum", m -> this.notNull(m) && this.toClass(m).isEnum());
        this.selector("member", m -> this.notNull(m) && this.toClass(m).isMemberClass());
        this.selector("local", m -> this.notNull(m) && this.toClass(m).isLocalClass());
        this.selector("extends", m -> {
            if (m == null) {
                return false;
            }
            Class<?> superClass = this.toClass(m).getSuperclass();
            return superClass != null && !"java.lang.Object".equals(superClass.getCanonicalName());
        });
        this.regexSelector("extends", (m, regex) -> this.notNull(m) && regex.matcher(this.toClass(m).getSuperclass().getCanonicalName()).find());
        this.regexSelector("simpleName", (m, regex) -> this.notNull(m) && regex.matcher(this.toClass(m).getSimpleName()).find());
        this.regexSelector("canonicalName", (m, regex) -> this.notNull(m) && regex.matcher(this.toClass(m).getCanonicalName()).find());
        this.regexSelector("implements", (m, regex) -> this.notNull(m) && Selector.classImplements(this.toClass(m), regex));
    }

    private void methodOnlySelectors() {
        this.selector("synthetic", m -> this.only(m, Method.class) && (this.getModifiers(m) & 0x1000) != 0);
        this.selector("synchronized", m -> this.only(m, Method.class) && Modifier.isSynchronized(this.getModifiers(m)));
        this.selector("native", m -> this.only(m, Method.class) && Modifier.isNative(this.getModifiers(m)));
        this.selector("strict", m -> this.only(m, Method.class) && Modifier.isStrict(this.getModifiers(m)));
        this.selector("default", m -> this.only(m, Method.class) && ((Member)m).getDeclaringClass().isInterface() && !Modifier.isAbstract(this.getModifiers(m)));
        this.selector("bridge", m -> this.only(m, Method.class) && ((Method)m).isBridge());
        this.selector("vararg", m -> this.only(m, Method.class) && ((Method)m).isVarArgs());
        this.selector("overrides", m -> this.only(m, Method.class) && this.methodOverrides((Method)m));
        this.selector("void", m -> this.only(m, Method.class) && ((Method)m).getReturnType().equals(Void.TYPE));
        this.regexSelector("returns", (m, regex) -> this.only(m, Method.class) && regex.matcher(((Method)m).getReturnType().getCanonicalName()).find());
        this.regexSelector("throws", (m, regex) -> this.only(m, Method.class) && Arrays.stream(((Method)m).getGenericExceptionTypes()).anyMatch(exception -> regex.matcher(exception.getTypeName()).find()));
        this.regexSelector("signature", (m, regex) -> this.only(m, Method.class) && regex.matcher(MethodTool.methodSignature((Method)m)).find());
    }

    private void fieldOnlySelectors() {
        this.selector("transient", m -> this.only(m, Field.class) && Modifier.isTransient(this.getModifiers(m)));
        this.selector("volatile", m -> this.only(m, Field.class) && Modifier.isVolatile(this.getModifiers(m)));
    }

    private void universalSelectors() {
        this.selector("true", m -> true);
        this.selector("false", m -> false);
        this.selector("null", Objects::isNull);
        this.selector("private", m -> this.notNull(m) && Modifier.isPrivate(this.getModifiers(m)));
        this.selector("protected", m -> this.notNull(m) && Modifier.isProtected(this.getModifiers(m)));
        this.selector("package", m -> this.notNull(m) && !Modifier.isPublic(this.getModifiers(m)) && !Modifier.isProtected(this.getModifiers(m)) && !Modifier.isPrivate(this.getModifiers(m)));
        this.selector("public", m -> m != null && Modifier.isPublic(this.getModifiers(m)));
        this.selector("static", m -> m != null && Modifier.isStatic(this.getModifiers(m)));
        this.selector("final", m -> m != null && Modifier.isFinal(this.getModifiers(m)));
        this.regexSelector("name", (m, regex) -> m != null && regex.matcher(this.getName(m)).find());
    }

    private String getName(T m) {
        if (m instanceof Member) {
            return ((Member)m).getName();
        }
        if (m instanceof Class) {
            return ((Class)m).getName();
        }
        throw this.illegalArgumentException("Cannot get the name for " + m.getClass().getCanonicalName());
    }

    private int getModifiers(T m) {
        if (m instanceof Member) {
            return ((Member)m).getModifiers();
        }
        if (m instanceof Class) {
            return ((Class)m).getModifiers();
        }
        throw this.illegalArgumentException("Cannot get the modifiers for " + m.getClass().getCanonicalName());
    }

    private boolean methodImplements(Method m) {
        if (m.getDeclaringClass().isInterface() && !m.isDefault() || Modifier.isAbstract(m.getModifiers())) {
            return false;
        }
        Set<Class<?>> interfaces = this.collectInterfaces(m.getDeclaringClass());
        for (Class<?> intarface : interfaces) {
            Class<?>[] args = m.getParameterTypes();
            String name = m.getName();
            if (!this.classHas(intarface, name, args)) continue;
            return true;
        }
        return false;
    }

    private boolean methodOrClassImplements(Object m) {
        if (m instanceof Method) {
            return this.methodImplements((Method)m);
        }
        if (m instanceof Class) {
            return Selector.classImplements((Class)m);
        }
        return false;
    }

    private static boolean classImplements(Class<?> klass) {
        if (klass.isInterface()) {
            return false;
        }
        Class<?>[] interfaces = klass.getInterfaces();
        return interfaces != null && interfaces.length > 0;
    }

    private static boolean classImplements(Class<?> klass, Pattern regex) {
        Class<?>[] interfaces;
        if (klass.isInterface()) {
            return false;
        }
        for (Class<?> iface : interfaces = klass.getInterfaces()) {
            if (!regex.matcher(iface.getName()).find()) continue;
            return true;
        }
        return false;
    }

    private Set<Class<?>> collectInterfaces(Class<?> klass) {
        HashSet returnSet = new HashSet();
        for (Class<?> interfAce : klass.getInterfaces()) {
            this.collectInterfaces(interfAce, returnSet);
        }
        return returnSet;
    }

    private void collectInterfaces(Class<?> klass, Set<Class<?>> returnSet) {
        if (returnSet.contains(klass)) {
            return;
        }
        returnSet.add(klass);
        for (Class<?> interfAce : klass.getInterfaces()) {
            this.collectInterfaces(interfAce, returnSet);
        }
    }

    private boolean methodOverrides(Method m) {
        Class<?>[] args = m.getParameterTypes();
        String name = m.getName();
        for (Class<?> klass = m.getDeclaringClass().getSuperclass(); klass != null; klass = klass.getSuperclass()) {
            if (!this.classHas(klass, name, args)) continue;
            return true;
        }
        return false;
    }

    private boolean classHas(Class<?> klass, String name, Class<?>[] args) {
        try {
            klass.getDeclaredMethod(name, args);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    private boolean only(T m, Class<?> ... classes) {
        if (m == null) {
            return false;
        }
        for (Class<?> klass : classes) {
            if (!klass.isAssignableFrom(m.getClass())) continue;
            return true;
        }
        throw this.illegalArgumentException("Selector cannot be applied to " + m.getClass());
    }

    public Selector converterRe(String name, Function<T, Object> function) {
        this.converters.put(name, function);
        return this;
    }

    public Selector converter(String name, Function<T, Object> function) {
        if (this.converters.containsKey(name)) {
            throw this.illegalArgumentException("The converter '" + name + "' is already defined, can not be redefined");
        }
        return this.converterRe(name, function);
    }

    public Selector selector(String name, Function<T, Boolean> function) {
        if (this.selectors.containsKey(name)) {
            throw this.illegalArgumentException("The selector '" + name + "' is already defined, can not be redefined");
        }
        return this.selectorRe(name, function);
    }

    public Selector selectorRe(String name, Function<T, Boolean> function) {
        this.selectors.put(name, function);
        return this;
    }

    public Selector regexSelector(String name, BiFunction<T, Pattern, Boolean> function) {
        this.regexMemberSelectors.put(name, function);
        return this;
    }

    public boolean match(Object member) {
        return this.match(member, this.top);
    }

    private boolean matchOr(T m, SelectorNode.Or node) {
        for (SelectorNode sub : node.subNodes) {
            if (!this.match(m, sub)) continue;
            return true;
        }
        return false;
    }

    private boolean matchAnd(T m, SelectorNode.And node) {
        for (SelectorNode sub : node.subNodes) {
            if (this.match(m, sub)) continue;
            return false;
        }
        return true;
    }

    private boolean match(T m, SelectorNode node) {
        if (node instanceof SelectorNode.Or) {
            return this.matchOr(m, (SelectorNode.Or)node);
        }
        if (node instanceof SelectorNode.And) {
            return this.matchAnd(m, (SelectorNode.And)node);
        }
        if (node instanceof SelectorNode.Converted) {
            String converter = ((SelectorNode.Converted)node).converter;
            Function<T, Object> function = this.converters.get(converter);
            if (function == null) {
                throw this.illegalArgumentException("There is no converter for '" + converter + "'");
            }
            return this.match(function.apply(m), ((SelectorNode.Converted)node).subNode);
        }
        if (node instanceof SelectorNode.Not) {
            return !this.match(m, ((SelectorNode.Not)node).subNode);
        }
        if (node instanceof SelectorNode.Regex) {
            SelectorNode.Regex regexNode = (SelectorNode.Regex)node;
            if (!this.regexMemberSelectors.containsKey(regexNode.name)) {
                throw this.illegalArgumentException("There is no regex matcher functionality for '" + regexNode.name + "'");
            }
            return this.regexMemberSelectors.get(regexNode.name).apply(m, regexNode.regex);
        }
        if (node instanceof SelectorNode.Terminal) {
            SelectorNode.Terminal terminalNode = (SelectorNode.Terminal)node;
            if (!this.selectors.containsKey(terminalNode.terminal)) {
                throw this.illegalArgumentException("The selector '" + terminalNode.terminal + "' is not known.");
            }
            return this.selectors.get(terminalNode.terminal).apply(m);
        }
        throw this.illegalArgumentException("Invalid node type in the compiled structure");
    }

    private boolean hasAnnotations(AnnotatedElement m) {
        Annotation[] ann = m.getAnnotations();
        return ann != null && ann.length > 0;
    }

    private boolean matchAnnotations(AnnotatedElement m, Pattern pattern) {
        return Arrays.stream(m.getAnnotations()).anyMatch(a -> pattern.matcher(a.annotationType().getCanonicalName()).find());
    }

    private IllegalArgumentException illegalArgumentException(String message) {
        IllegalArgumentException exception = new IllegalArgumentException(message + " in expression '" + this.expression + "'");
        StackTraceElement[] elements = exception.getStackTrace();
        StackTraceElement[] trace = new StackTraceElement[elements.length - 1];
        System.arraycopy(elements, 1, trace, 0, trace.length);
        exception.setStackTrace(trace);
        return exception;
    }
}

