/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.tools.reflection;

import java.lang.reflect.Modifier;
import java.util.function.Predicate;

public class ModifiersBuilder {
    private final StringBuilder s = new StringBuilder();
    private final int modifiers;
    private boolean isMethod = true;

    public ModifiersBuilder(int modifiers) {
        this.modifiers = modifiers;
    }

    private void check(Predicate<Integer> predicate, String text) {
        if (predicate.test(this.modifiers)) {
            this.s.append(text);
        }
    }

    public ModifiersBuilder field() {
        this.isMethod = false;
        return this;
    }

    public String toString() {
        this.s.setLength(0);
        this.check(Modifier::isPrivate, "private ");
        this.check(Modifier::isProtected, "protected ");
        this.check(Modifier::isPublic, "public ");
        this.check(Modifier::isFinal, "final ");
        this.check(Modifier::isStatic, "static ");
        this.check(Modifier::isSynchronized, "synchronized ");
        this.check(Modifier::isStrict, "strictfp ");
        this.check(Modifier::isAbstract, "abstract ");
        if (!this.isMethod) {
            this.check(Modifier::isVolatile, "volatile ");
            this.check(Modifier::isTransient, "transient ");
        }
        return this.s.toString();
    }
}

