/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.tools;

import java.util.ArrayList;
import java.util.List;

public class Untabber {
    public static List<String> untab(List<String> lines) {
        return Untabber.untab(lines, 0);
    }

    public static List<String> untab(List<String> lines, int to) {
        int untab = Untabber.calculateTabbing(lines);
        ArrayList<String> untabbed = new ArrayList<String>();
        for (String line : lines) {
            untabbed.add(" ".repeat(to) + (line.length() >= untab ? line.substring(untab) : ""));
        }
        return untabbed;
    }

    private static int calculateTabbing(List<String> lines) {
        int min = Integer.MAX_VALUE;
        for (String line : lines) {
            int spaces;
            int stripped = line.stripLeading().length();
            if (stripped <= 0 || (spaces = line.length() - stripped) >= min) continue;
            min = spaces;
        }
        return min;
    }
}

