/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax0.geci.api.GeciException;
import javax0.geci.log.Logger;
import javax0.geci.log.LoggerFactory;

public class Tracer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger();
    private static final String DEFAULT_TAG = "log";
    private static Tracer root;
    private static Tracer current;
    private static Tracer last;
    private String popTrace;
    private static final Tracer FAKE;
    private final Tracer parent;
    private final ArrayList<Tracer> children = new ArrayList();
    private String message;
    private final String tag;
    private final String cData;

    private Tracer(Tracer parent, String message, String tag, String cData) {
        this.parent = parent;
        this.message = message;
        this.tag = tag;
        this.cData = cData;
    }

    public static void on() {
        root = new Tracer(null, "tracer root", "trace", null);
        Tracer.resetCurrentAndLast();
    }

    public static void off() {
        root = null;
        Tracer.resetCurrentAndLast();
    }

    private static void resetCurrentAndLast() {
        current = root;
        last = root;
    }

    private static Tracer walkUpTo(String tag) {
        Tracer walk = last;
        while (walk != null && !walk.tag.equals(tag)) {
            walk = walk.parent;
        }
        if (walk == null) {
            GeciException e = new GeciException("Walking upward in trace there is no tag '" + tag + "'", new Object[0]);
            Tracer.log((Throwable)e);
        }
        return walk;
    }

    public static void prepend(String tag, String msg) {
        if (last == null) {
            return;
        }
        Tracer my = Tracer.walkUpTo(tag);
        if (my != null) {
            if (my.message == null) {
                my.message = "";
            }
            my.message = msg + my.message;
        }
    }

    public static void append(String tag, String msg) {
        if (last == null) {
            return;
        }
        Tracer my = Tracer.walkUpTo(tag);
        if (my != null) {
            if (my.message == null) {
                my.message = "";
            }
            my.message = my.message + msg;
        }
    }

    public static void prepend(String msg) {
        if (last == null) {
            return;
        }
        if (Tracer.last.message == null) {
            Tracer.last.message = "";
        }
        Tracer.last.message = msg + Tracer.last.message;
    }

    public static void append(String msg) {
        if (last == null) {
            return;
        }
        if (Tracer.last.message == null) {
            Tracer.last.message = "";
        }
        Tracer.last.message = Tracer.last.message + msg;
    }

    public static void log(String msg) {
        Tracer.log(DEFAULT_TAG, msg);
    }

    public static void log(String tag, String msg) {
        Tracer.log(tag, msg, null);
    }

    public static void log(String tag, String msg, String cData) {
        if (root == null) {
            return;
        }
        last = new Tracer(current, msg, tag, cData);
        Tracer.current.children.add(last);
    }

    public static Tracer push(String msg) {
        return Tracer.push(DEFAULT_TAG, msg);
    }

    public static Tracer push(String tag, String msg) {
        if (root == null) {
            return FAKE;
        }
        Tracer actual = current;
        last = new Tracer(current, msg, tag, null);
        Tracer.current.children.add(last);
        current = last;
        return actual;
    }

    public static void pop() {
        if (root == null) {
            return;
        }
        if (Tracer.current.parent != null) {
            Tracer.current.popTrace = new TracerPop().getStackTrace()[1].toString();
            current = Tracer.current.parent;
        } else {
            GeciException e = new GeciException("Too many Tracer.pop() calls", new Object[0]);
            Tracer.log((Throwable)e);
        }
    }

    public static void pop(Tracer actual) {
        if (root == null) {
            return;
        }
        Tracer stepper = Tracer.current.parent;
        while (stepper != null && stepper != actual) {
            stepper = stepper.parent;
        }
        if (stepper == null) {
            Tracer child;
            stepper = actual;
            while ((child = Tracer.lastChild(stepper)) != null && child.popTrace != null) {
                stepper = child;
            }
            current = actual;
            try (Tracer tracer = Tracer.push("PopTrace", null);){
                while (stepper != null && stepper.popTrace != null) {
                    Tracer.log("Pop", stepper.popTrace);
                    stepper = stepper.parent;
                }
            }
        }
        current = actual;
    }

    private static Tracer lastChild(Tracer tracer) {
        if (tracer.children.isEmpty()) {
            return null;
        }
        return tracer.children.get(tracer.children.size() - 1);
    }

    @Override
    public void close() {
        Tracer.pop(this);
    }

    public static void log(Throwable e) {
        Tracer.log("ERROR", null, Tracer.exceptionToString(e));
    }

    private static String exceptionToString(Throwable e) {
        String result = "";
        try (StringWriter sw = new StringWriter();
             PrintWriter pw = new PrintWriter(sw);){
            e.printStackTrace(pw);
            result = sw.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static void dumpXML(String fileName) throws IOException {
        if (root == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        Tracer.dumpXML(sb);
        File file = new File(fileName);
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(sb.toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    public static void dumpXML(StringBuilder sb) {
        if (root == null) {
            return;
        }
        Tracer.dumpXML(root, sb, 0);
    }

    private static void dumpXML(Tracer node, StringBuilder sb, int tab) {
        String messageTag;
        if (tab > 200) {
            sb.append(" ".repeat(tab)).append("<FATAL message=\"Nesting of trace messages is too deep, probably internal error.\"/>");
            return;
        }
        String string = messageTag = node.message != null ? " msg=\"" + Tracer.escape(node.message) + "\"" : "";
        if (node.children.isEmpty()) {
            if (node.cData == null) {
                sb.append(" ".repeat(tab)).append("<").append(node.tag).append(messageTag).append("/>").append("\n");
            } else {
                sb.append(" ".repeat(tab)).append("<").append(node.tag).append(messageTag).append(">").append("\n");
                sb.append("<![CDATA[").append(node.cData).append("]]>\n");
                sb.append(" ".repeat(tab)).append("</").append(node.tag).append(">\n");
            }
        } else {
            sb.append(" ".repeat(tab)).append("<").append(node.tag).append(messageTag).append(">").append("\n");
            node.children.forEach(c -> Tracer.dumpXML(c, sb, tab + 2));
            sb.append(" ".repeat(tab)).append("</").append(node.tag).append(">\n");
        }
    }

    private static String escape(String s) {
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;");
    }

    static {
        FAKE = new Tracer(null, null, null, null);
    }

    private static class TracerPop
    extends RuntimeException {
        private TracerPop() {
        }
    }
}

