/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.tools;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;

public class TemplateLoader {
    private static final ClassLoader loader = TemplateLoader.class.getClassLoader();
    private static final String QUOTE = "```";

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getTemplateContent(String template) {
        if (template == null) {
            return null;
        }
        if (template.startsWith(QUOTE) && template.endsWith(QUOTE)) {
            return template.substring(3, template.length() - 3);
        }
        try {
            URL resource = loader.getResource(template);
            if (resource != null) {
                return new String(Files.readAllBytes(Paths.get(TemplateLoader.fix(resource.getFile()), new String[0])), StandardCharsets.UTF_8).replaceAll("\r\n", "\n");
            }
            return "/* template '" + template + "' was not loaded */";
        }
        catch (IOException e) {
            try (StringWriter sw = new StringWriter();){
                PrintWriter pw = new PrintWriter(sw);
                try {
                    e.printStackTrace(pw);
                    String string = "/* template '" + template + "' was not loaded : \n" + sw.toString() + "*/";
                    pw.close();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        pw.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ioegnored) {
                return "/* template '" + template + "' was not loaded\n*/";
            }
        }
    }

    public static String quote(String s) {
        return QUOTE + s + QUOTE;
    }

    private static String fix(String s) {
        if (s != null && s.length() > 2 && s.charAt(0) == '/' && s.charAt(2) == ':') {
            return s.substring(1);
        }
        return s;
    }
}

