/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.tools;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax0.geci.tools.GeciReflectionTools;

public class MethodTool {
    protected final AtomicInteger argCounter = new AtomicInteger(0);
    protected Method method;
    private String type = null;
    private boolean isInterface = false;
    private boolean isPublic = false;
    private Function<String, String> decorator;

    public static MethodTool with(Method method) {
        MethodTool it = new MethodTool();
        it.method = method;
        return it;
    }

    public MethodTool forThe(Method method) {
        this.method = method;
        return this;
    }

    public MethodTool withType(String type) {
        this.type = type;
        return this;
    }

    public MethodTool decorateNameWith(Function<String, String> decorator) {
        this.decorator = decorator;
        return this;
    }

    public MethodTool asInterface() {
        this.isInterface = true;
        return this;
    }

    public MethodTool asPublic() {
        this.isPublic = true;
        return this;
    }

    public static String methodSignature(Method method) {
        return MethodTool.with(method).signature();
    }

    public String signature() {
        return this.signature(false);
    }

    public String signature(boolean concrete) {
        Type[] types = this.method.getGenericParameterTypes();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            if (i == types.length - 1 && this.method.isVarArgs()) {
                sb.append(this.getVarArg(types[i]));
                continue;
            }
            sb.append(this.getArg(types[i]));
        }
        String arglist = sb.toString();
        String exceptionlist = Arrays.stream(this.method.getGenericExceptionTypes()).map(GeciReflectionTools::getGenericTypeName).collect(Collectors.joining(","));
        Object modifiers = this.isPublic ? (concrete ? (this.isInterface ? "" : "public " + GeciReflectionTools.modifiersStringNoAccessConcrete(this.method)) : (this.isInterface ? "" : "public " + GeciReflectionTools.modifiersStringNoAccess(this.method))) : (concrete ? (this.isInterface ? "" : GeciReflectionTools.modifiersStringConcrete(this.method)) : (this.isInterface ? "" : GeciReflectionTools.modifiersString(this.method)));
        return (String)modifiers + (this.type == null ? GeciReflectionTools.typeAsString(this.method) : this.type) + " " + this.decoratedName(this.method) + "(" + arglist + ")" + (String)(exceptionlist.length() == 0 ? "" : " throws " + exceptionlist);
    }

    public String call() {
        String arglist = Arrays.stream(this.method.getGenericParameterTypes()).map(this::getArgCall).collect(Collectors.joining(","));
        return this.decoratedName(this.method) + "(" + arglist + ")";
    }

    public String getArgCall(Type t) {
        String normType = GeciReflectionTools.getGenericTypeName(t);
        return "arg" + this.argCounter.addAndGet(1);
    }

    public String getVarArg(Type t) {
        String normType = GeciReflectionTools.getGenericTypeName(t);
        String actualType = normType.substring(0, normType.length() - 2) + "... ";
        return actualType + " arg" + this.argCounter.addAndGet(1);
    }

    public String getArg(Type t) {
        String normType = GeciReflectionTools.getGenericTypeName(t);
        return normType + " arg" + this.argCounter.addAndGet(1);
    }

    private String decoratedName(Method method) {
        if (this.decorator == null) {
            return method.getName();
        }
        return this.decorator.apply(method.getName());
    }
}

