/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.tools;

class Levenshtein {
    private static final int MAX_COST = 5;
    private int maxCost;

    Levenshtein() {
    }

    static int distance(String x, String y) {
        Levenshtein lev = new Levenshtein();
        lev.maxCost = 5;
        return lev.calculate(x, y, 0);
    }

    private int calculate(String x, String y, int cost) {
        if (cost >= this.maxCost) {
            return this.maxCost;
        }
        if (x.isEmpty()) {
            return y.length();
        }
        if (y.isEmpty()) {
            return x.length();
        }
        int thisCost = x.charAt(0) == y.charAt(0) ? 0 : 1;
        int substitution = this.calculate(x.substring(1), y.substring(1), cost + thisCost) + thisCost;
        int insertion = this.calculate(x, y.substring(1), cost + 1) + 1;
        int min = Math.min(substitution, insertion);
        int deletion = this.calculate(x.substring(1), y, cost + 1) + 1;
        return Math.min(min, deletion);
    }
}

