/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.tools;

import java.util.Arrays;
import javax0.geci.annotations.Geci;

@Geci(value={"fluent definedBy='javax0.geci.buildfluent.TestBuildFluentForSourceBuilder::sourceBuilderGrammar'"})
public class JavaSource
implements AutoCloseable {
    private static final int TAB = 4;
    private final StringBuilder code = new StringBuilder();
    private final MethodSetup lastMethod = new MethodSetup();
    private int tabStop = 0;

    public static Builder builder() {
        return new Wrapper();
    }

    public JavaSource write(String s, Object ... parameters) {
        if (s.trim().length() == 0) {
            this.newline();
        } else {
            String formatted = String.format(s, parameters);
            if (formatted.contains("\n")) {
                Arrays.stream(formatted.split("\r?\n")).forEach(x$0 -> this.write((String)x$0, new Object[0]));
            } else {
                formatted = formatted.replaceAll("\n+$", "");
                this.code.append(this.tabStop > 0 ? String.format("%" + this.tabStop + "s", " ") : "").append(formatted).append("\n");
            }
        }
        return this;
    }

    public JavaSource newline() {
        this.code.append("\n");
        return this;
    }

    public JavaSource write_r(String s, Object ... parameters) {
        this.write(s, parameters);
        this.tabStop += 4;
        return this;
    }

    public JavaSource write_l(String s, Object ... parameters) {
        this.tabStop -= 4;
        if (this.tabStop < 0) {
            this.tabStop = 0;
        }
        this.write(s, parameters);
        return this;
    }

    public JavaSource write_lr(String s, Object ... parameters) {
        this.tabStop -= 4;
        if (this.tabStop < 0) {
            this.tabStop = 0;
        }
        this.write_r(s, parameters);
        return this;
    }

    public String toString() {
        return this.code.toString();
    }

    public JavaSource method(String name) {
        this.lastMethod.name = name;
        this.lastMethod.type = "void";
        this.lastMethod.modifiers = "";
        this.lastMethod.exceptions = "";
        return this;
    }

    public JavaSource modifiers(String modifiers) {
        this.lastMethod.modifiers = modifiers;
        return this;
    }

    public JavaSource returnType(String type) {
        this.lastMethod.type = type;
        return this;
    }

    public JavaSource exceptions(String exceptions) {
        this.lastMethod.exceptions = exceptions;
        return this;
    }

    public JavaSource args(String ... args) {
        String argList = String.join((CharSequence)",", args);
        StringBuilder sb = new StringBuilder();
        if (this.lastMethod.modifiers != null && this.lastMethod.modifiers.length() > 0) {
            sb.append(this.lastMethod.modifiers).append(" ");
        }
        sb.append(this.lastMethod.type).append(" ");
        sb.append(this.lastMethod.name).append("(").append(argList).append(")");
        if (this.lastMethod.exceptions != null && this.lastMethod.exceptions.length() > 0) {
            sb.append(" throws ").append(this.lastMethod.exceptions);
        }
        return this.open(sb.toString(), new Object[0]);
    }

    public JavaSource noArgs() {
        return this.args(new String[0]);
    }

    public JavaSource open(String s, Object ... parameters) {
        s = (String)s + "{";
        this.write_r((String)s, parameters);
        return this;
    }

    public JavaSource comment(String s, Object ... parameters) {
        s = "// " + (String)s;
        this.write((String)s, parameters);
        return this;
    }

    public JavaSource statement(String s, Object ... parameters) {
        s = (String)s + ";";
        this.write((String)s, parameters);
        return this;
    }

    public JavaSource whileStatement(String s, Object ... parameters) {
        s = "while( " + (String)s + " ){";
        this.write_r((String)s, parameters);
        return this;
    }

    public JavaSource forStatement(String s, Object ... parameters) {
        s = "for( " + (String)s + " ){";
        this.write_r((String)s, parameters);
        return this;
    }

    public JavaSource ifStatement(String s, Object ... parameters) {
        s = "if( " + (String)s + " ){";
        this.write_r((String)s, parameters);
        return this;
    }

    public JavaSource elseStatement() {
        this.write_lr("}else{", new Object[0]);
        return this;
    }

    public JavaSource returnStatement() {
        this.statement("return", new Object[0]);
        return this;
    }

    public JavaSource returnStatement(String s, Object ... parameters) {
        s = "return " + (String)s;
        this.statement((String)s, parameters);
        return this;
    }

    @Override
    public void close() {
        this.write_l("}", new Object[0]);
    }

    private static class MethodSetup {
        String name;
        String modifiers;
        String type;
        String exceptions;

        private MethodSetup() {
        }
    }

    public static interface Ukeg
    extends Afube,
    AutoCloseable,
    Aduf {
    }

    public static interface Afube
    extends Udoh,
    Oded,
    Abok,
    Efeh,
    Ujaj,
    Ogoj,
    AutoCloseable,
    Ehebe,
    Edak,
    Acuh,
    Ohug,
    Agak {
    }

    public static interface Ehebe {
        public Ucok whileStatement(String var1, Object ... var2);
    }

    public static interface Ucok
    extends Ukeg,
    Okuk,
    AutoCloseable {
    }

    public static interface Okuk {
        public Ucok comment(String var1, Object ... var2);

        public Ucok newline();

        public Ucok open(String var1, Object ... var2);

        public Ucok statement(String var1, Object ... var2);

        public Ucok write(String var1, Object ... var2);

        public Ucok write_l(String var1, Object ... var2);

        public Ucok write_r(String var1, Object ... var2);
    }

    public static interface Agak {
        public Obaj forStatement(String var1, Object ... var2);
    }

    public static interface Obaj
    extends Ukeg,
    Ejoj,
    AutoCloseable {
    }

    public static interface Ejoj {
        public Obaj comment(String var1, Object ... var2);

        public Obaj newline();

        public Obaj open(String var1, Object ... var2);

        public Obaj statement(String var1, Object ... var2);

        public Obaj write(String var1, Object ... var2);

        public Obaj write_l(String var1, Object ... var2);

        public Obaj write_r(String var1, Object ... var2);
    }

    public static interface Udoh {
        public Ekog ifStatement(String var1, Object ... var2);
    }

    public static interface Ekog
    extends Ahah,
    AutoCloseable,
    Ebud {
    }

    public static interface Ahah {
        public Ekog comment(String var1, Object ... var2);

        public Ekog newline();

        public Ekog open(String var1, Object ... var2);

        public Ekog statement(String var1, Object ... var2);

        public Ekog write(String var1, Object ... var2);

        public Ekog write_l(String var1, Object ... var2);

        public Ekog write_r(String var1, Object ... var2);
    }

    public static interface Ebud
    extends Ukeg,
    Oceg,
    AutoCloseable {
    }

    public static interface Oceg {
        public Ajef elseStatement();
    }

    public static interface Ajef
    extends Ukeg,
    AutoCloseable,
    Ufuf {
    }

    public static interface Ufuf {
        public Ajef comment(String var1, Object ... var2);

        public Ajef newline();

        public Ajef open(String var1, Object ... var2);

        public Ajef statement(String var1, Object ... var2);

        public Ajef write(String var1, Object ... var2);

        public Ajef write_l(String var1, Object ... var2);

        public Ajef write_r(String var1, Object ... var2);
    }

    public static interface Oded {
        public Uguc method(String var1);
    }

    public static interface Uguc
    extends Akec,
    AutoCloseable {
        public Akec modifiers(String var1);
    }

    public static interface Akec
    extends Ecac,
    AutoCloseable {
        public Ecac returnType(String var1);
    }

    public static interface Ecac
    extends AutoCloseable,
    Ofob {
        public Ofob exceptions(String var1);
    }

    public static interface Ofob {
        public MethodBody args(String ... var1);

        public MethodBody noArgs();
    }

    public static interface MethodBody
    extends Ukeg,
    AutoCloseable,
    Uhab {
    }

    public static interface Uhab {
        public MethodBody comment(String var1, Object ... var2);

        public MethodBody newline();

        public MethodBody open(String var1, Object ... var2);

        public MethodBody returnStatement();

        public MethodBody returnStatement(String var1, Object ... var2);

        public MethodBody statement(String var1, Object ... var2);

        public MethodBody write(String var1, Object ... var2);

        public MethodBody write_l(String var1, Object ... var2);

        public MethodBody write_r(String var1, Object ... var2);
    }

    public static interface Abok {
        public Ukeg write_r(String var1, Object ... var2);
    }

    public static interface Edak {
        public Ukeg write_l(String var1, Object ... var2);
    }

    public static interface Ogoj {
        public Ukeg write(String var1, Object ... var2);
    }

    public static interface Ujaj {
        public Ukeg statement(String var1, Object ... var2);
    }

    public static interface Acuh {
        public Ukeg open(String var1, Object ... var2);
    }

    public static interface Efeh {
        public Ukeg newline();
    }

    public static interface Ohug {
        public Ukeg comment(String var1, Object ... var2);
    }

    public static interface Aduf {
        public String toString();
    }

    public static class Wrapper
    implements Ecac,
    Ejoj,
    Abok,
    Efeh,
    Builder,
    Edak,
    Acuh,
    Aduf,
    Afube,
    Udoh,
    Ucok,
    AutoCloseable,
    Uguc,
    Ufuf,
    Ebud,
    Ohug,
    Ofob,
    Agak,
    Ukeg,
    MethodBody,
    Oded,
    Ahah,
    Oceg,
    Ajef,
    Ujaj,
    Ogoj,
    Akec,
    Okuk,
    Ehebe,
    Obaj,
    Uhab,
    Ekog {
        private final JavaSource that = new JavaSource();

        @Override
        public Wrapper ifStatement(String arg1, Object ... arg2) {
            this.that.ifStatement(arg1, arg2);
            return this;
        }

        @Override
        public Wrapper statement(String arg1, Object ... arg2) {
            this.that.statement(arg1, arg2);
            return this;
        }

        @Override
        public Wrapper returnStatement() {
            this.that.returnStatement();
            return this;
        }

        @Override
        public Wrapper forStatement(String arg1, Object ... arg2) {
            this.that.forStatement(arg1, arg2);
            return this;
        }

        @Override
        public Wrapper write_r(String arg1, Object ... arg2) {
            this.that.write_r(arg1, arg2);
            return this;
        }

        @Override
        public String toString() {
            return this.that.toString();
        }

        @Override
        public Wrapper open(String arg1, Object ... arg2) {
            this.that.open(arg1, arg2);
            return this;
        }

        @Override
        public Wrapper elseStatement() {
            this.that.elseStatement();
            return this;
        }

        @Override
        public Wrapper method(String arg1) {
            this.that.method(arg1);
            return this;
        }

        @Override
        public Wrapper noArgs() {
            this.that.noArgs();
            return this;
        }

        @Override
        public Wrapper returnStatement(String arg1, Object ... arg2) {
            this.that.returnStatement(arg1, arg2);
            return this;
        }

        @Override
        public Wrapper comment(String arg1, Object ... arg2) {
            this.that.comment(arg1, arg2);
            return this;
        }

        @Override
        public Wrapper modifiers(String arg1) {
            this.that.modifiers(arg1);
            return this;
        }

        @Override
        public Wrapper args(String ... arg1) {
            this.that.args(arg1);
            return this;
        }

        @Override
        public Wrapper write_l(String arg1, Object ... arg2) {
            this.that.write_l(arg1, arg2);
            return this;
        }

        @Override
        public Wrapper whileStatement(String arg1, Object ... arg2) {
            this.that.whileStatement(arg1, arg2);
            return this;
        }

        @Override
        public Wrapper exceptions(String arg1) {
            this.that.exceptions(arg1);
            return this;
        }

        @Override
        public Wrapper returnType(String arg1) {
            this.that.returnType(arg1);
            return this;
        }

        @Override
        public Wrapper write(String arg1, Object ... arg2) {
            this.that.write(arg1, arg2);
            return this;
        }

        @Override
        public void close() {
            this.that.close();
        }

        @Override
        public Wrapper newline() {
            this.that.newline();
            return this;
        }
    }

    public static interface Builder
    extends Ukeg {
    }
}

