/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.tools;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax0.geci.api.GeciException;
import javax0.geci.tools.CompoundParams;
import javax0.geci.tools.GeciAnnotationTools;
import javax0.geci.tools.MethodTool;
import javax0.geci.tools.reflection.ModifiersBuilder;
import javax0.geci.tools.reflection.Selector;

public class GeciReflectionTools {
    public static final int PACKAGE = 65536;
    private static final Selector inheritedField = Selector.compile("!static & !private");
    private static final Selector inheritedFieldDifferentPackage = Selector.compile("!static & !private & !package");
    private static final Map<String, Class<?>> PRIMITIVES = Map.of("byte", Byte.TYPE, "char", Character.TYPE, "short", Short.TYPE, "int", Integer.TYPE, "long", Long.TYPE, "float", Float.TYPE, "double", Double.TYPE, "boolean", Boolean.TYPE);

    public static CompoundParams getParameters(AnnotatedElement element, String generatorMnemonic) {
        String[] strings;
        for (String string : strings = GeciAnnotationTools.getGecis(element)) {
            CompoundParams params = GeciAnnotationTools.getParameters(generatorMnemonic, string);
            if (params == null) continue;
            return params;
        }
        return null;
    }

    public static Invoker invoke(String methodName) {
        Invoker invoker = new Invoker();
        invoker.methodName = methodName;
        return invoker;
    }

    public static String modifiersString(Method method) {
        return new ModifiersBuilder(method.getModifiers()).toString();
    }

    public static String modifiersStringConcrete(Method method) {
        return new ModifiersBuilder(method.getModifiers() & 0xFFFFFBFF).toString();
    }

    public static String modifiersStringNoAccess(Method method) {
        return new ModifiersBuilder(method.getModifiers() & 0xFFFFFFFB & 0xFFFFFFFD & 0xFFFFFFFE).toString();
    }

    public static String modifiersStringNoAccessConcrete(Method method) {
        return new ModifiersBuilder(method.getModifiers() & 0xFFFFFFFB & 0xFFFFFFFD & 0xFFFFFFFE & 0xFFFFFBFF).toString();
    }

    public static String typeAsString(Member member) {
        return GeciReflectionTools.getGenericTypeName(member instanceof Field ? ((Field)member).getGenericType() : ((Method)member).getGenericReturnType());
    }

    public static String normalizeTypeName(String s) {
        if ((s = s.replaceAll("\\s*<\\s*", "<").replaceAll("\\s*>\\s*", ">").replaceAll("\\s*\\.\\s*", ".").replaceAll("\\s*,\\s*", ",").replaceAll("\\s+", " ")).startsWith("java.lang.")) {
            s = s.substring("java.lang.".length());
        }
        s = s.replaceAll("([^\\w\\d.^])java.lang.", "$1");
        s = s.replaceAll("\\$", ".");
        return s;
    }

    public static String normalizeTypeName(String s, Class<?> klass) {
        if ((s = GeciReflectionTools.normalizeTypeName(s)).startsWith(klass.getPackageName() + ".")) {
            s = s.substring(klass.getPackageName().length() + 1);
        }
        return s;
    }

    private static String removeJavaLang(String s) {
        if (s.startsWith("java.lang.") && !s.substring("java.lang.".length()).contains(".")) {
            return s.substring("java.lang.".length());
        }
        return s;
    }

    public static String getGenericTypeName(Type t) {
        Object normalizedName;
        if (t instanceof ParameterizedType) {
            normalizedName = GeciReflectionTools.getGenericParametrizedTypeName((ParameterizedType)t);
        } else if (t instanceof Class) {
            normalizedName = GeciReflectionTools.removeJavaLang(((Class)t).getCanonicalName());
        } else if (t instanceof WildcardType) {
            normalizedName = GeciReflectionTools.getGenericWildcardTypeName((WildcardType)t);
        } else if (t instanceof GenericArrayType) {
            GenericArrayType at = (GenericArrayType)t;
            normalizedName = GeciReflectionTools.getGenericTypeName(at.getGenericComponentType()) + "[]";
        } else if (t instanceof TypeVariable) {
            normalizedName = t.getTypeName();
        } else {
            throw new GeciException("Type is something not handled. It is '%s' for the type '%s'", new Object[]{t.getClass(), t.getTypeName()});
        }
        return normalizedName;
    }

    public static String getSimpleGenericClassName(Class<?> t) {
        return t.getSimpleName() + GeciReflectionTools.getGenericParametersString(t);
    }

    public static String getLocalGenericClassName(Class<?> t) {
        return GeciReflectionTools.normalizeTypeName(t.getCanonicalName().substring(t.getPackageName().length() + 1)) + GeciReflectionTools.getGenericParametersString(t);
    }

    private static String getGenericParametersString(Class<?> t) {
        String generics = Arrays.stream(t.getTypeParameters()).map(GeciReflectionTools::getGenericTypeName).collect(Collectors.joining(","));
        if (generics.length() == 0) {
            return "";
        }
        return "<" + generics + ">";
    }

    private static String getGenericWildcardTypeName(WildcardType t) {
        String ub = GeciReflectionTools.joinTypes(t.getUpperBounds());
        String lb = GeciReflectionTools.joinTypes(t.getLowerBounds());
        String normalizedName = "?" + (String)(lb.length() > 0 && !lb.equals("Object") ? " super " + lb : "") + (String)(ub.length() > 0 && !ub.equals("Object") ? " extends " + ub : "");
        return normalizedName;
    }

    private static String getGenericParametrizedTypeName(ParameterizedType t) {
        Type[] types = t.getActualTypeArguments();
        if (!(t.getRawType() instanceof Class)) {
            throw new GeciException("'getRawType()' returned something that is not a class : " + t.getClass().getTypeName(), new Object[0]);
        }
        Class klass = (Class)t.getRawType();
        String klassName = GeciReflectionTools.removeJavaLang(klass.getCanonicalName());
        Object normalizedName = types.length > 0 ? klassName + "<" + GeciReflectionTools.joinTypes(types) + ">" : klassName;
        return normalizedName;
    }

    private static String joinTypes(Type[] types) {
        return Arrays.stream(types).map(GeciReflectionTools::getGenericTypeName).collect(Collectors.joining(","));
    }

    public static Field[] getDeclaredFieldsSorted(Class<?> klass) {
        Field[] fields = klass.getDeclaredFields();
        Arrays.sort(fields, Comparator.comparing(Field::getName));
        return fields;
    }

    public static Field[] getAllFieldsSorted(Class<?> klass) {
        HashSet<Field> allFields = new HashSet<Field>(Arrays.asList(klass.getDeclaredFields()));
        boolean samePackage = true;
        for (Class<?> currentClass = klass.getSuperclass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            samePackage = samePackage && klass.getPackage() == currentClass.getPackage();
            GeciReflectionTools.collectFields(samePackage, currentClass, allFields);
        }
        Field[] fieldsArray = allFields.toArray(new Field[0]);
        Arrays.sort(fieldsArray, Comparator.comparing(Field::getName));
        return fieldsArray;
    }

    private static void collectFields(boolean isSamePackage, Class<?> actualClass, Set<Field> fields) {
        Field[] declaredFields = actualClass.getDeclaredFields();
        Selector selector = isSamePackage ? inheritedField : inheritedFieldDifferentPackage;
        Arrays.stream(declaredFields).filter(selector::match).forEach(fields::add);
    }

    public static Method[] getDeclaredMethodsSorted(Class<?> klass) {
        Method[] methods = klass.getDeclaredMethods();
        Arrays.sort(methods, Comparator.comparing(MethodTool::methodSignature));
        return methods;
    }

    public static Method[] getMethodsSorted(Class<?> klass) {
        Method[] methods = klass.getMethods();
        Arrays.sort(methods, Comparator.comparing(MethodTool::methodSignature));
        return methods;
    }

    public static Method[] getAllMethodsSorted(Class<?> klass) {
        ArrayList<Method> allMethods = new ArrayList<Method>(Arrays.asList(klass.getDeclaredMethods()));
        boolean samePackage = true;
        for (Class<?> currentClass = klass.getSuperclass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            samePackage = samePackage && klass.getPackage() == currentClass.getPackage();
            GeciReflectionTools.collectMethods(samePackage, currentClass, allMethods);
        }
        Method[] methodArray = allMethods.toArray(new Method[0]);
        Arrays.sort(methodArray, Comparator.comparing(MethodTool::methodSignature));
        return methodArray;
    }

    private static void collectMethods(boolean samePackage, Class<?> currentClass, ArrayList<Method> allMethods) {
        Arrays.stream(currentClass.getDeclaredMethods()).filter(method -> GeciReflectionTools.isVisible(method, samePackage)).filter(method -> GeciReflectionTools.isNotOverridden(method, allMethods)).forEach(allMethods::add);
    }

    private static boolean isNotOverridden(Method currentMethod, ArrayList<Method> allMethods) {
        return !allMethods.stream().filter(method -> method.getName().equals(currentMethod.getName())).anyMatch(method -> Arrays.deepEquals(method.getParameterTypes(), currentMethod.getParameterTypes()));
    }

    private static boolean isVisible(Method method, boolean samePackage) {
        int modifier = method.getModifiers();
        return Modifier.isProtected(modifier) || Modifier.isPublic(modifier) || samePackage && !Modifier.isPublic(modifier) && !Modifier.isProtected(modifier) && !Modifier.isPrivate(modifier);
    }

    public static Class[] getAllClassesSorted(Class<?> klass) {
        Set classes = Arrays.stream(klass.getClasses()).collect(Collectors.toSet());
        Set declaredClasses = Arrays.stream(klass.getDeclaredClasses()).collect(Collectors.toSet());
        HashSet allClasses = new HashSet();
        allClasses.addAll(classes);
        allClasses.addAll(declaredClasses);
        Class[] classArray = allClasses.toArray(new Class[0]);
        Arrays.sort(classArray, Comparator.comparing(Class::getName));
        return classArray;
    }

    public static Class[] getDeclaredClassesSorted(Class<?> klass) {
        Class[] classes = klass.getDeclaredClasses();
        Arrays.sort(classes, Comparator.comparing(Class::getName));
        return classes;
    }

    public static Class[] getClassesSorted(Class<?> klass) {
        Class[] classes = klass.getClasses();
        Arrays.sort(classes, Comparator.comparing(Class::getName));
        return classes;
    }

    public static Method getMethod(Class<?> klass, String methodName, Class<?> ... classes) throws NoSuchMethodException {
        return Stream.of(GeciReflectionTools.getAllMethodsSorted(klass)).filter(method -> method.getName().equals(methodName) && Arrays.deepEquals(method.getParameterTypes(), classes)).findAny().orElseThrow(() -> new NoSuchMethodException("No method " + methodName + " was found in " + klass.getName()));
    }

    public static Field getField(Class<?> klass, String fieldName) throws NoSuchFieldException {
        return Stream.of(GeciReflectionTools.getAllFieldsSorted(klass)).filter(field -> field.getName().equals(fieldName)).findAny().orElseThrow(() -> new NoSuchFieldException("No field " + fieldName + " was found in " + klass.getName()));
    }

    private static Class<?> classForNoArray(String className) throws ClassNotFoundException {
        if (PRIMITIVES.containsKey(className)) {
            return PRIMITIVES.get(className);
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ignored) {
            return Class.forName("java.lang." + className);
        }
    }

    public static Class<?> classForName(String className) throws ClassNotFoundException {
        int arrayCounter = 0;
        while (className.endsWith("[]")) {
            className = className.substring(0, className.length() - 2);
            ++arrayCounter;
        }
        Class<?> klass = GeciReflectionTools.classForNoArray(className);
        while (arrayCounter-- > 0) {
            klass = Array.newInstance(klass, 0).getClass();
        }
        return klass;
    }

    public static int mask(String masks, int dfault) {
        int modMask = 0;
        if (masks == null) {
            return dfault;
        }
        block28: for (String maskString : masks.split(",", -1)) {
            String maskTrimmed;
            switch (maskTrimmed = maskString.trim()) {
                case "private": {
                    modMask |= 2;
                    continue block28;
                }
                case "public": {
                    modMask |= 1;
                    continue block28;
                }
                case "protected": {
                    modMask |= 4;
                    continue block28;
                }
                case "static": {
                    modMask |= 8;
                    continue block28;
                }
                case "package": {
                    modMask |= 0x10000;
                    continue block28;
                }
                case "abstract": {
                    modMask |= 0x400;
                    continue block28;
                }
                case "final": {
                    modMask |= 0x10;
                    continue block28;
                }
                case "interface": {
                    modMask |= 0x200;
                    continue block28;
                }
                case "synchronized": {
                    modMask |= 0x20;
                    continue block28;
                }
                case "native": {
                    modMask |= 0x100;
                    continue block28;
                }
                case "transient": {
                    modMask |= 0x80;
                    continue block28;
                }
                case "volatile": {
                    modMask |= 0x40;
                    continue block28;
                }
                default: {
                    throw new IllegalArgumentException(maskTrimmed + " can not be used as a modifier string");
                }
            }
        }
        return modMask;
    }

    public static class Invoker {
        private String methodName;
        private Object target;
        Class[] types;

        public Invoker1 on(Object target) {
            this.target = target;
            return new Invoker1();
        }

        public class Invoker2 {
            public Object args(Object ... args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
                Method method = Invoker.this.target.getClass().getMethod(Invoker.this.methodName, Invoker.this.types);
                method.setAccessible(true);
                return method.invoke(Invoker.this.target, args);
            }
        }

        public class Invoker1 {
            public Invoker2 types(Class ... types) {
                Invoker.this.types = types;
                return new Invoker2();
            }
        }
    }
}

