/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.tools;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax0.geci.api.GeciException;
import javax0.geci.api.Source;
import javax0.geci.tools.CaseTools;
import javax0.geci.tools.CompoundParams;
import javax0.geci.tools.CompoundParamsBuilder;
import javax0.geci.tools.reflection.Selector;

public class GeciAnnotationTools {
    private static final Pattern SEGMENT_HEADER_PATTERN = Pattern.compile("//\\s*<\\s*editor-fold(.*)>");
    private static final Pattern ANNOTATION_PATTERN = Pattern.compile("@Geci\\(\"(.*)\"\\)");
    private static final Pattern pattern = Pattern.compile("([\\w\\d_$]+)\\s*=\\s*'(.*?)'");

    public static String[] getGecis(AnnotatedElement element) {
        return (String[])GeciAnnotationTools.getDeclaredAnnotationUnwrapped(element).filter(GeciAnnotationTools::isAnnotationGeci).map(GeciAnnotationTools::getValue).toArray(String[]::new);
    }

    private static Stream<Annotation> getDeclaredAnnotationUnwrapped(AnnotatedElement element) {
        Annotation[] allAnnotations = element.getDeclaredAnnotations();
        return Arrays.stream(allAnnotations).flatMap(GeciAnnotationTools::getSelfOrRepeated);
    }

    private static Stream<Annotation> getSelfOrRepeated(Annotation annotation) {
        try {
            Method value = annotation.annotationType().getMethod("value", new Class[0]);
            value.setAccessible(true);
            if (Annotation[].class.isAssignableFrom(value.getReturnType())) {
                return Stream.of((Annotation[])value.invoke((Object)annotation, new Object[0]));
            }
            return Stream.of(annotation);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return Stream.of(annotation);
        }
    }

    private static boolean isAnnotationGeci(Annotation annotation) {
        return GeciAnnotationTools.isAnnotationGeci(annotation, new HashSet<Annotation>());
    }

    private static boolean isAnnotationGeci(Annotation annotation, Set<Annotation> checked) {
        checked.add(annotation);
        if (GeciAnnotationTools.annotationName(annotation).equals("Geci")) {
            return true;
        }
        Annotation[] annotations = annotation.annotationType().getDeclaredAnnotations();
        return Arrays.stream(annotations).filter(x -> !checked.contains(x)).anyMatch(x -> GeciAnnotationTools.isAnnotationGeci(x, checked));
    }

    private static String annotationName(Annotation a) {
        return a.annotationType().getSimpleName();
    }

    static String getValue(Annotation annotation) {
        try {
            String rawValue = GeciAnnotationTools.getRawValue(annotation);
            String annotationName = GeciAnnotationTools.getAnnotationGeciName(annotation);
            StringBuilder value = GeciAnnotationTools.getValue(CaseTools.lcase(annotationName), rawValue.trim());
            for (Method method : GeciAnnotationTools.getAnnotationDeclaredMethods(annotation)) {
                String param;
                if (!method.getReturnType().equals(String.class) || method.getName().equals("value") || method.getName().equals("toString") || (param = GeciAnnotationTools.geParam(annotation, method)) == null || param.length() <= 0) continue;
                value.append(" ").append(method.getName()).append("='").append(param).append("'");
            }
            return value.toString();
        }
        catch (ClassCastException e) {
            throw new GeciException("Cannot use '" + GeciAnnotationTools.annotationName(annotation) + "' as generator annotation.", (Throwable)e);
        }
    }

    private static String getAnnotationGeciName(Annotation annotation) {
        String selfName = annotation.annotationType().getSimpleName();
        Annotation[] annotations = annotation.annotationType().getDeclaredAnnotations();
        Optional<String> renamedName = Arrays.stream(annotations).filter(GeciAnnotationTools::isAnnotationGeci).map(GeciAnnotationTools::getRawValue).findFirst();
        return renamedName.isPresent() && renamedName.get().length() > 0 ? renamedName.get() : selfName;
    }

    private static String geParam(Annotation annotation, Method method) {
        try {
            method.setAccessible(true);
            return (String)method.invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return "";
        }
    }

    private static String getRawValue(Annotation annotation) {
        try {
            Method valueMethod = GeciAnnotationTools.getAnnotationValueMethod(annotation);
            valueMethod.setAccessible(true);
            Object value = valueMethod.invoke((Object)annotation, new Object[0]);
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof String[]) {
                CharSequence[] values = (String[])value;
                return String.join((CharSequence)" ", values);
            }
            throw new IllegalArgumentException("The annotation " + GeciAnnotationTools.annotationName(annotation) + " value() return type is not String or String[]");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return "";
        }
    }

    private static Method getAnnotationValueMethod(Annotation annotation) throws NoSuchMethodException {
        return annotation.annotationType().getDeclaredMethod("value", new Class[0]);
    }

    private static Method[] getAnnotationDeclaredMethods(Annotation annotation) {
        return annotation.annotationType().getDeclaredMethods();
    }

    private static StringBuilder getValue(String annotationName, String value) {
        String mnemonic;
        int mnemonicEnd = value.indexOf(32);
        String string = mnemonic = mnemonicEnd == -1 ? value : value.substring(0, mnemonicEnd);
        if (mnemonic.contains("=") || mnemonic.length() == 0) {
            return new StringBuilder(annotationName).append(value.length() == 0 ? "" : " ").append(value);
        }
        return new StringBuilder(value);
    }

    public static boolean isGenerated(AnnotatedElement element) {
        return Selector.compile("annotation ~ /Generated/").match(element);
    }

    public static CompoundParams getParameters(Source source, String generatorMnemonic, String prefix, Pattern nextLine) {
        CompoundParams paramConditional = null;
        for (String line : source.getLines()) {
            if (paramConditional != null && (nextLine == null || nextLine.matcher(line).find())) {
                return paramConditional;
            }
            Matcher match = GeciAnnotationTools.getMatch(prefix, line);
            if (match.matches()) {
                if (paramConditional != null) continue;
                String string = match.group(1);
                paramConditional = GeciAnnotationTools.getParameters(generatorMnemonic, string);
                continue;
            }
            paramConditional = null;
        }
        return null;
    }

    @Deprecated
    public static CompoundParams getSegmentParameters(Source source, String mnemonic) {
        for (String line : source.getLines()) {
            CompoundParams params;
            String trimmedLine = line.trim();
            Matcher headerMatcher = SEGMENT_HEADER_PATTERN.matcher(trimmedLine);
            if (!headerMatcher.matches() || !mnemonic.equals((params = new CompoundParamsBuilder(headerMatcher.group(1)).exclude("desc").redefineId().build()).id())) continue;
            return params;
        }
        return null;
    }

    public static CompoundParams getParameters(String generatorMnemonic, String string) {
        if (string.startsWith(generatorMnemonic + " ") || string.equals(generatorMnemonic)) {
            return new CompoundParamsBuilder(string).redefineId().build();
        }
        return null;
    }

    private static Matcher getMatch(String prefix, String line) {
        String trimmedLine = line.trim();
        String chopped = prefix != null && trimmedLine.startsWith(prefix) ? trimmedLine.substring(prefix.length()) : trimmedLine;
        String matchLine = chopped.trim();
        return ANNOTATION_PATTERN.matcher(matchLine);
    }

    @Deprecated
    public static Map<String, String> getParameters(String s) {
        HashMap<String, String> pars = new HashMap<String, String>();
        Matcher matcher = pattern.matcher(s);
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = matcher.group(2);
            pars.put(key, value);
        }
        return pars;
    }
}

