/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax0.geci.api.GeciException;
import javax0.geci.javacomparator.LexicalElement;
import javax0.geci.javacomparator.lex.Lexer;
import javax0.geci.javacomparator.lex.LexicalElement;
import javax0.geci.tools.CompoundParams;

public class CompoundParamsBuilder {
    private final String line;
    private final List<String> excludedKeys = new ArrayList<String>();
    private boolean redefine = false;

    public CompoundParamsBuilder(String line) {
        this.line = line;
    }

    public CompoundParamsBuilder redefineId() {
        this.redefine = true;
        return this;
    }

    public CompoundParamsBuilder exclude(String ... keys) {
        this.excludedKeys.addAll(Arrays.asList(keys));
        return this;
    }

    public CompoundParams build() {
        int startAt;
        LexicalElement[] elements;
        HashMap params = new HashMap();
        Lexer lexer = new Lexer();
        try {
            elements = lexer.apply(Collections.singletonList(this.line));
        }
        catch (IllegalArgumentException iae) {
            throw new GeciException("Cannot parse the line for parameters: " + this.line, (Throwable)iae);
        }
        if (elements.length < 1) {
            this.throwMalformed(this.line);
        }
        String name = "";
        if (elements[0].type == LexicalElement.Type.IDENTIFIER && elements.length < 2 || elements.length > 1 && elements[1].type != LexicalElement.Type.SYMBOL) {
            name = elements[0].lexeme;
            startAt = 1;
        } else {
            startAt = 0;
        }
        for (int i = startAt; i < elements.length; ++i) {
            if (elements[i].type != LexicalElement.Type.IDENTIFIER) {
                this.throwMalformed(this.line);
            }
            String key = elements[i].lexeme;
            if (++i >= elements.length || !elements[i].type.is(LexicalElement.Type.SYMBOL) || !elements[i].lexeme.equals("=")) {
                this.throwMalformed(this.line);
            }
            if (++i >= elements.length || !elements[i].type.is(LexicalElement.Type.STRING, LexicalElement.Type.CHARACTER, LexicalElement.Type.FLOAT, LexicalElement.Type.INTEGER, LexicalElement.Type.IDENTIFIER)) {
                this.throwMalformed(this.line);
            }
            String value = elements[i].lexeme;
            if (this.redefine && "id".equals(key)) {
                name = value;
                continue;
            }
            if ("id".equals(key)) {
                throw new GeciException("id is not allowed as parameter name in '" + this.line + "'", new Object[0]);
            }
            if (this.excludedKeys.contains(key)) continue;
            if (!params.containsKey(key)) {
                params.put(key, new ArrayList());
            }
            ((List)params.get(key)).add(value);
        }
        return new CompoundParams(name, params);
    }

    private void throwMalformed(String s) {
        throw new GeciException("snippet pattern is malformed '" + s + "'", new Object[0]);
    }
}

