/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax0.geci.api.GeciException;
import javax0.geci.api.Source;
import javax0.geci.tools.Levenshtein;
import javax0.geci.tools.Tracer;

public class CompoundParams
implements javax0.geci.api.CompoundParams {
    private static final String Q = "\"";
    private final Map<String, List<String>>[] params;
    private final CompoundParams[] cparams;
    private final String id;
    private Set<String> allowedKeys = null;
    private Source source = null;
    private String mnemonic = null;

    @SafeVarargs
    public CompoundParams(String id, Map<String, ?> ... params) {
        this.params = new HashMap[params.length];
        for (int i = 0; i < params.length; ++i) {
            this.params[i] = new HashMap<String, List<String>>();
            for (Map.Entry<String, ?> entry : params[i].entrySet()) {
                this.params[i].put(entry.getKey(), CompoundParams.valueToList(entry.getValue()));
            }
        }
        this.cparams = null;
        this.id = id;
    }

    private static List<String> valueToList(Object value) {
        if (value instanceof List) {
            return CompoundParams.assertListOfStrings((List)value);
        }
        if (value instanceof String) {
            return new ArrayList<String>(Collections.singletonList((String)value));
        }
        throw new IllegalArgumentException(value.getClass() + " cannot be used in " + CompoundParams.class.getSimpleName() + " as parameter value.");
    }

    private static List<String> assertListOfStrings(List value) {
        for (Object string : value) {
            if (string instanceof String) continue;
            throw new IllegalArgumentException(value.getClass() + " cannot be used in " + CompoundParams.class.getSimpleName() + " as parameter value as it contains non-String elements.");
        }
        return value;
    }

    public CompoundParams(CompoundParams ... cparams) {
        this.params = null;
        this.cparams = cparams;
        this.id = CompoundParams.find(c -> c.id, cparams);
        this.source = CompoundParams.find(c -> c.source, cparams);
        this.mnemonic = CompoundParams.find(c -> c.mnemonic, cparams);
        this.allowedKeys = CompoundParams.find(c -> c.allowedKeys, cparams);
        if (this.source != null && this.mnemonic != null && this.allowedKeys != null) {
            this.checkAllowedKeys();
        }
    }

    public void trace() {
        for (String key : this.keySet()) {
            Tracer.log(key, this.get(key));
        }
    }

    private static <T> T find(Function<CompoundParams, T> mapper, CompoundParams ... cparams) {
        return Arrays.stream(cparams).filter(Objects::nonNull).map(mapper).filter(Objects::nonNull).limit(1L).findFirst().orElse(null);
    }

    public void setConstraints(Source source, String mnemonic, Set<String> allowedKeys) {
        this.source = source;
        this.mnemonic = mnemonic;
        this.allowedKeys = allowedKeys;
        if (source != null && allowedKeys != null) {
            this.checkAllowedKeys();
        }
    }

    private void checkAllowedKeys() {
        StringBuilder errorMessage = new StringBuilder();
        for (String key : this.keySet()) {
            if (this.allowedKeys.contains(key)) continue;
            String closestKey = null;
            int closestDistance = Integer.MAX_VALUE;
            for (String s : this.allowedKeys) {
                int d = Levenshtein.distance(key, s);
                if (d == closestDistance) {
                    closestKey = null;
                }
                if (d >= closestDistance) continue;
                closestDistance = d;
                closestKey = s;
            }
            errorMessage.append("\nThe configuration '").append(key).append("' can not be used with the generator ").append(this.mnemonic).append((String)(closestKey == null ? "" : ", did you mean '" + closestKey + "' ?"));
        }
        if (errorMessage.length() > 0) {
            throw new GeciException(errorMessage.append("\nThe possible keys are:\n  ").append(String.join((CharSequence)", ", this.allowedKeys)).append("\nIn source code ").append(this.source.getAbsoluteFile()).toString(), new Object[0]);
        }
    }

    public String get(String key, String defaults) {
        return Optional.ofNullable(this.get0(key)).orElse(defaults);
    }

    public String get(String key, Supplier<String> defaultSupplier) {
        return Optional.ofNullable(this.get0(key)).orElse(defaultSupplier.get());
    }

    public String get(String key) {
        String value = this.get0(key);
        return value == null ? "" : value;
    }

    public String id(String mnemonic) {
        String id = this.get("id");
        return id.length() == 0 ? mnemonic : id;
    }

    private String get0(String key) {
        this.assertKeyAllowed(key);
        if (this.params != null) {
            return Arrays.stream(this.params).filter(Objects::nonNull).filter(p -> p.containsKey(key)).map(p -> (String)((List)p.get(key)).get(0)).findFirst().orElse("id".equals(key) ? this.id : null);
        }
        if (this.cparams != null) {
            return Arrays.stream(this.cparams).filter(Objects::nonNull).map(p -> p.get0(key)).filter(Objects::nonNull).findFirst().orElse("id".equals(key) ? this.id : null);
        }
        if ("id".equals(key)) {
            return this.id;
        }
        return null;
    }

    private void assertKeyAllowed(String key) {
        if (this.allowedKeys != null && !this.allowedKeys.contains(key)) {
            throw new GeciException("Generator is accessing key '" + key + "' which it does not list as an allowed key. This is a generator bug.", new Object[0]);
        }
    }

    public List<String> getValueList(String key, List<String> defaults) {
        List<String> list = this.getValueList(key);
        if (list != null) {
            return list;
        }
        return defaults;
    }

    public List<String> getValueList(String key) {
        if (this.params != null) {
            return Arrays.stream(this.params).filter(Objects::nonNull).filter(p -> p.containsKey(key)).map(p -> (List)p.get(key)).findFirst().orElse("id".equals(key) ? Collections.singletonList(this.id) : null);
        }
        if (this.cparams != null) {
            return Arrays.stream(this.cparams).filter(Objects::nonNull).map(p -> p.getValueList(key)).filter(Objects::nonNull).findFirst().orElse("id".equals(key) ? Collections.singletonList(this.id) : null);
        }
        if ("id".equals(key)) {
            return Collections.singletonList(this.id);
        }
        return null;
    }

    public boolean is(String key) {
        String s = this.get(key);
        return javax0.geci.api.CompoundParams.toBoolean((String)s);
    }

    public boolean is(String key, boolean defaultValue) {
        String s = this.get(key);
        if (s.isEmpty()) {
            return defaultValue;
        }
        return javax0.geci.api.CompoundParams.toBoolean((String)s);
    }

    public boolean is(String key, String defaultValue) {
        String s = this.get(key);
        if (s.isEmpty()) {
            s = defaultValue;
        }
        return javax0.geci.api.CompoundParams.toBoolean((String)s);
    }

    public Set<String> keySet() {
        Stream<Set> keyStream = this.params != null ? Arrays.stream(this.params).filter(Objects::nonNull).map(Map::keySet) : (this.cparams != null ? Arrays.stream(this.cparams).filter(Objects::nonNull).map(CompoundParams::keySet) : Stream.of(new Set[0]));
        return keyStream.filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public String toString() {
        return "{ " + this.keySet().stream().map(k -> Q + k + "\":\"" + this.get((String)k) + Q).collect(Collectors.joining(",")) + " }";
    }
}

