/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.tools;

import java.util.function.Function;

public class CaseTools {
    public static String lcase(String s) {
        return CaseTools.xcase(s, Character::toLowerCase);
    }

    public static String ucase(String s) {
        return CaseTools.xcase(s, Character::toUpperCase);
    }

    private static String xcase(String s, Function<Character, Character> f) {
        if (s == null || s.length() == 0) {
            return s;
        }
        return f.apply(Character.valueOf(s.charAt(0))) + (s.length() > 1 ? s.substring(1) : "");
    }

    public static String camel(String s) {
        if (s == null) {
            return null;
        }
        char[] result = new char[s.length()];
        int dst = 0;
        boolean capIt = true;
        for (int src = 0; src < s.length(); ++src) {
            if (s.charAt(src) == '_') {
                capIt = true;
                continue;
            }
            if (capIt) {
                capIt = false;
                result[dst++] = Character.toUpperCase(s.charAt(src));
                continue;
            }
            result[dst++] = Character.toLowerCase(s.charAt(src));
        }
        return new String(result, 0, dst);
    }

    public static String snake(String s) {
        if (s == null) {
            return null;
        }
        int dst = 0;
        char[] result = new char[2 * s.length()];
        for (int src = 0; src < s.length(); ++src) {
            if (Character.isUpperCase(s.charAt(src)) && src > 0) {
                result[dst++] = 95;
            }
            result[dst++] = Character.toUpperCase(s.charAt(src));
        }
        return new String(result, 0, dst);
    }
}

