/*
 * Decompiled with CFR 0.152.
 */
package javax0.geci.tools;

import java.lang.reflect.Method;
import javax0.geci.api.Segment;
import javax0.geci.api.Source;
import javax0.geci.tools.AbstractJavaGenerator;
import javax0.geci.tools.CompoundParams;
import javax0.geci.tools.GeciReflectionTools;

public abstract class AbstractMethodsGenerator
extends AbstractJavaGenerator {
    protected boolean declaredOnly = true;

    @Override
    public final void process(Source source, Class<?> klass, CompoundParams global) throws Exception {
        Method[] methods;
        this.preprocessHook(source, klass, global);
        for (Method method : methods = this.declaredOnly ? GeciReflectionTools.getDeclaredMethodsSorted(klass) : GeciReflectionTools.getAllMethodsSorted(klass)) {
            CompoundParams params = GeciReflectionTools.getParameters(method, this.mnemonic());
            this.processMethodHook(source, klass, new CompoundParams(params, global), method);
        }
        this.processMethodHook(source, klass, global, methods);
        this.postprocessHook(source, klass, global);
    }

    public void preprocess(Source source, Class<?> klass, CompoundParams global) throws Exception {
        try (Segment segment = source.safeOpen(global.id(this.mnemonic()));){
            this.preprocess(source, klass, global, segment);
        }
    }

    public void preprocess(Source source, Class<?> klass, CompoundParams global, Segment segment) throws Exception {
    }

    protected void preprocessHook(Source source, Class<?> klass, CompoundParams global) throws Exception {
        this.preprocess(source, klass, global);
    }

    public void postprocess(Source source, Class<?> klass, CompoundParams global) throws Exception {
        this.postprocess(source, klass, global, source.safeOpen(global.id(this.mnemonic())));
    }

    public void postprocess(Source source, Class<?> klass, CompoundParams global, Segment segment) throws Exception {
    }

    public void postprocessHook(Source source, Class<?> klass, CompoundParams global) throws Exception {
        this.postprocess(source, klass, global);
    }

    protected void processMethodHook(Source source, Class<?> klass, CompoundParams params, Method method) throws Exception {
        this.process(source, klass, params, method);
    }

    protected void processMethodHook(Source source, Class<?> klass, CompoundParams global, Method[] methods) throws Exception {
        this.process(source, klass, global, methods);
    }

    public void process(Source source, Class<?> klass, CompoundParams params, Method method) throws Exception {
        try (Segment segment = source.safeOpen(params.id(this.mnemonic()));){
            this.process(source, klass, params, method, segment);
        }
    }

    public void process(Source source, Class<?> klass, CompoundParams params, Method method, Segment segment) throws Exception {
    }

    public void process(Source source, Class<?> klass, CompoundParams global, Method[] methods) throws Exception {
        try (Segment segment = source.safeOpen(global.id(this.mnemonic()));){
            this.process(source, klass, global, methods, segment);
        }
    }

    public void process(Source source, Class<?> klass, CompoundParams global, Method[] methods, Segment segment) throws Exception {
    }
}

